package MBootstrap;

use MCoreTools;
use MLoaders;

sub create_world {
  mudlog "BOOTSTRAP: Creating basic world...";

  MZone->new('/core');
  MZone->new('/lib/species');
  
  MObject->new_proto('/core/roomproto',
    comment => 'Room prototype. All rooms should inherit from this.',
    name => 'An Unfinished Room',
    idesc => 'You are in an unfinished room.',
    sky_vis => 1,
  );
  MObject->new_proto('/core/ashes',
    comment => 'Used by @destroy.',
    name => 'a pile of ashes',
    ldesc => 'A small pile of black ashes. They are very coarse, as if whatever produced them burned rapidly',
    weight => 0.001,
  );

  $::Rooms{'/core/void'} = new MObject (
    roomname => '/core/void',
    'prototype' => '/core/roomproto',
    name => 'The Void',
    peaceful => 1,
    no_wander => 1,
    idesc => '<self.vis?Total blackness is all you can see<self.aud?, and :. >><self.aud?<self.vis?c:C>omplete silence reaches your ears. >You can feel nothing at all, not even gravity or your own body.',
    location => [0,0,0],
  );

  MObject->new_proto('/lib/species/human',
    'prototype' => '/lib/species/humanoid',
    'name' => 'a human being',
    ok_for_pc => 1,
    ldesc => 'A very ordinary-looking person.',
  );
  MObject->new_proto('/lib/species/horse',
    'prototype' => '/lib/species/herbivore',
    'name' => 'a horse',
    ok_for_pc => 1,
    for_sitting => 1,
    glance_contents => 1,
    weight => 800,
    interior => 800,
    'allow_genders' => {
      'female' => 1,
      'male' => 1
    },
  );
  MObject->new_proto('/lib/species/humanoid',
    'density' => '.9',
    'name' => 'a humanoid',
    'prototype' => '/lib/species/generic',
    'weight' => 180,
    'has_body_pos' => 1,
    can_speak => 1,
    'allow_genders' => {
      'female' => 1,
      'male' => 1
    },
    'cnt_interior' => 1000,
    'has_slot' => {
      'on arms' => {
        'max_weight' => 35,
        'max_volume' => 35,
        'gerund' => 'wearing',
        'verb' => 'wear'
      },
      'in right hand' => {
        'max_weight' => 150,
        'max_volume' => 150,
        'gerund' => 'holding',
        'verb' => 'hold'
      },
      'on left ring finger' => {
        'max_weight' => '.5',
        'max_volume' => '.5',
        'gerund' => 'wearing',
        'verb' => 'wear'
      },
      'on left hand' => {
        'max_weight' => 1,
        'max_volume' => 1,
        'gerund' => 'wearing',
        'verb' => 'wear'
      },
      'on torso' => {
        'max_weight' => 80,
        'max_volume' => 80,
        'gerund' => 'wearing',
        'verb' => 'wear'
      },
      'on right ring finger' => {
        'max_weight' => '.5',
        'max_volume' => '.5',
        'gerund' => 'wearing',
        'verb' => 'wear'
      },
      'on right hand' => {
        'max_weight' => 1,
        'max_volume' => 1,
        'gerund' => 'wearing',
        'verb' => 'wear'
      },
      'on legs' => {
        'max_weight' => 40,
        'max_volume' => 40,
        'gerund' => 'wearing',
        'verb' => 'wear'
      },
      'in left hand' => {
        'max_weight' => 150,
        'max_volume' => 150,
        'gerund' => 'holding',
        'verb' => 'hold'
      }
    },
  );
  MObject->new_proto('/lib/species/herbivore',
    'prototype' => '/lib/species/generic',
    rideable => 1,
  );
  MObject->new_proto('/lib/species/generic',
    'm_hit' => 100,
    'm_move' => 100,
    'name' => '<generic creature>',
    'comment' => 'Use this to inherit attributes of basic "aliveness".',
    'has_metabolism' => 1,
    squirmy => 1,
    enter_prep => 'on',
    cnt_type => 'open',
    voluntary_carry => 1,
  );
  
  my $z = MZone->by_path('/core');
  $z->save_zinf();
  $z = MZone->by_path('/lib/species');
  $z->save_zinf();
  MObject->save_prototypes('/core');
  MObject->save_prototypes('/lib/species');
  MLoaders->save_rooms('/core');
}

sub startup_checks {
  my ($class) = @_;
  if (!MZone->all_zones) {
    $class->create_world;
  }
}  

1;
