package MConnection::Capturing;
use strict;
use vars qw(
  @ISA
  %EscapeTable
);
@ISA = qw(MConnection);

%EscapeTable = (
  '&'  => '&',
  'z'  => '',
  'zz' => '',

  # for desc_gen
  'lt' => '<',
  'gt' => '>',
  colon => ':',
  excl => '!',
);

sub new {
  my ($class) = @_;
  
  my $self = $class->SUPER::new;
  $self->{captured} = '';

  return $self;
}

sub send_str_raw {
  my ($self, $text) = @_;
  $self->{captured} .= $text;
}

sub escape_handler {return sub {
  my ($self, $name, $semicolon) = @_;
  my $code = $EscapeTable{$name};
  return "&$name$semicolon" unless defined $code;
  return $code if ($code !~ /^\x1B/ or $self->{prefs}{color});
  return '';
}}

sub escape_rlen_handler {return sub {
  my ($self, $name, $semicolon) = @_;
  my $code = $EscapeTable{$name};
  return ($code !~ /^\x1B/ ? $code : '') if defined $code;
  return "&$name$semicolon";
}}

sub open {1}
sub source {"CAPTURE(".$_[0]->id.")"}
sub _read_input {}
sub captured {return $_[0]{captured}}

1;
