package MZonedHash::Prototypes;
use MZonedHash;
@ISA = qw(MZonedHash);

use strict;
use Carp qw();
use MCoreTools;

sub _type_swap_in {
  my ($self, $zone) = @_;
  my $zobj = MZone->by_path($zone) or do {
    mudlog "ERROR/WORLD: Access to nonexistent zone '$zone'";
    return;
  };
  return if $zobj->file_loaded('obj');
  #mudlog "On-demand load: obj:$zone";
  $zobj->load_file('obj');
}

sub _type_store_zoned {
  my ($self, $zone, $key, $value) = @_;
  MZone->by_path($zone)->key_store('obj', $key, $value);
}

sub _type_delete_zoned {
  my ($self, $zone, $key) = @_;
  MZone->by_path($zone)->key_delete('obj', $key);
}


1;
