my $showsub;
$showsub = sub {
  my ($val, $field, %opt) = @_;
  $field ||= '';
  my $nval;
  if (!defined $val) {
    $nval = '&y;undef&n;';
  } elsif (ref $val) {
    if (ref $val eq 'ARRAY') {
      if ($field eq 'extra_descs') {
        $nval = "&g;(&n;" . (join '&y;, &n;', map {$showsub->($_, 'extra_descs>>desc')} @$val) . "&g;)&n;";
      } else {
        $nval = "&y;[&n;" . (join '&y;, &n;', map {$showsub->($_)} @$val) . "&y;]&n;";
      }
    } elsif (ref $val eq 'HASH') {
      if ($field eq 'exits' or $field eq 'has_slot' or $field eq 'affects') {
        $nval = "&y;{&n;\n" . (join "&y;,\n&n;", map {"&c;$_&n: " . $showsub->($val->{$_})} keys %$val) . "&y;}&n;";
      } elsif ($field eq 'extra_descs>>desc') {
        $nval = "\n" . $showsub->($val->{keywords}) . " &y;=>&n; " . $showsub->($val->{desc}); 
      } else {
        $nval = "&y;{&n;" . (join '&y;, &n;', map {"&c;$_&n: " . $showsub->($val->{$_})} keys %$val) . "&y;}&n;";
      }
    } elsif (ref $val eq 'MObject') {
      (my $name = $val->name) =~ s/^(.{14})(.{3}).*/$1.../;
      $nval = "&y;OBJ{&n;" . $name . "&y;#&n;" . $val->id . "&y;}&n;";
    } elsif(ref $val eq 'CODE') {
      $nval = $val;
    } elsif (ref($val) =~ /^MConnection/) {
      $nval = "&y;CON{&n;" . $val->ip . ":" . $val->port . "&y;#&n;" . $val->id . "&y;}&n;";
    } else {
      $nval = "&y;ref type ".ref($val)."&n;";
    }
  } elsif ((0 and $val =~ /\n|.{80}/) or $opt{heredoc}) { # FIXME, abs length
    $nval = "<<'%%END%%'\n$val\n%%END%%";
    $nval =~ s/\n\nEND/\nEND/;
  } elsif ($val !~ m#^[-+]?[\w/.]+$#) {
    $nval = $val;
    $nval =~ s/'/\\'/g;
    $nval =~ s/&/&&/g;
    $nval = ($field eq 'ldesc' || $field eq 'idesc' ? "\n" : '') . qq{&y;'&n;$nval&y;'&n;};
  } else {
    $nval = $val;
  }
  $nval;
};

MObject->ModFields (
  'edit_zone' => {default => 'NONE'},
  'edit_target' => {nostore => 1},
  'edit_delete_confirm' => {},
  'unrestricted_edit' => {default => 0, requires => [qw(CONTROLLER)]},
);

MObject->Commands (
#print join ', ', (
'mload' => {
  requires => [qw(immortal CONTROLLER)],
  code => sub {
    my ($self, $args) = @_;
    $args or do {
      $self->send("Usage: mload <mpMUD module name>");
      return;
    };
    $self->send("Unloading old");
    MLoaders->unload_module($args);
    $self->send("Loading new");
    MLoaders->load_module($args);
    $self->send("Done");
  },
  help => <<'EOHELP',
mload <mpMUD module name>

Loads or reloads a mpMUD module.
EOHELP
},
'munload' => {
  requires => [qw(immortal CONTROLLER)],
  code => sub {
    my ($self, $args) = @_;
    $args or do {
      $self->send("Usage: munload <mpMUD module name>");
      return;
    };
    MLoaders->unload_module($args);
  },
  help => <<'EOHELP',
mload <mpMUD module name>

Loads or reloads a mpMUD module.
EOHELP
},
'reuse' => {
  requires => [qw(immortal CONTROLLER)],
  code => sub {
    my ($self, $args) = @_;
    $args or do {
      $self->send("Usage: reuse <Perl module>");
      return;
    };
    my $re = $args;
    $re =~ s/::/\\W+/;
    foreach (grep {$_ =~ /$re/} keys %INC) {
      delete $INC{$_};
    }
    mudlog "(PC) @{[$self->name]} re-used $args";
    local $SIG{__WARN__} = sub {$self->send($_[0]) unless $_[0] =~ /[Ss]ubroutine \w+ redefined|Ambiguous use of ({|\w+ =>)/};
    eval "use $args";
    $self->send($@) if $@;
  },
  help => <<'EOHELP',
reuse <Perl module>

Reloads a given Perl module. &sb;This command should NOT be used unless you are familiar with the operation of Perl and the code of mpMUD.&n 

Important to note is that this will not cause new imported symbols to be visible to existing packages; it only reloads the code. 

This command should usually only be used in emergency situations (for example, a player finds a loophole that lets them get unlimited cash/exp/whatever).
EOHELP
},
'rnew' => {
  requires => [qw(immortal)],
  code => sub {
    my ($self, $args) = @_;
    my ($dir, $name) = split /\s+/, $args;

    if (!$dir) {
      $self->send("In what direction?");
      return;
    }

    unless ($name and $name =~ m#/\w+/\w+#) {
      $self->send("That doesn't look like a valid path.");
      return;
    }

    if ($name !~ m#^@{[$self->edit_zone]}#) {
      $self->send("You do not have permission to edit that zone.");
      return;
    }

    if (!$self->container->roomname) {
      $self->send("You aren't in a room!");
      return;
    }

    if ($self->container->roomname !~ m#^@{[$self->edit_zone]}#) {
      $self->send("You do not have permission to edit this zone.");
      return;
    }

    if (!$self->opposite_dir($dir)) {
      $self->send("I don't know what the opposite of that direction is.");
      return;
    }

    if ($::Rooms{$name}) {
      $self->send("That room already exists!");
      return;
    }

    $::Rooms{$name} = new MObject (
      'prototype' => ROOM_PROTO,
      exits => {$self->opposite_dir($dir) => {to => $self->container->roomname}},
      roomname => $name,
    );
    $self->container->localize_field('exits');
    $self->container->exits->{$dir} = {to => $name};
    $self->act("Okay.",
               $self->name . " makes a throwing motion ${dir}ward.");
    $self->act(undef, "A bright flash fills the area!");
    mudlog "EDIT: " . $self->name . " created room $name linked from @{[$self->container->roomname]}";

    my ($zone) = $name =~ m#^(.*)/[^/]+$#;
    $::DirtyFiles{"room:$zone"} = 1;
    ($zone) = $self->container->roomname =~ m#^(.*)/[^/]+$#;
    $::DirtyFiles{"room:$zone"} = 1;
  },
  help => <<'EOHELP',
&c;RNEW&n;

rnew <direction> <path>

Creates an exit in <direction> to a new room named <path> with an exit leading back to the room you are in, in the opposite direction.
EOHELP
},
'save' => {
  requires => [qw(immortal)],
  code => sub {
    my ($self, $args) = @_;
    if (!$args or $args =~ /\?/) {
      $self->send('Unsaved files:');
      foreach (keys %::DirtyFiles) {
        $self->send("  * $_\n");
      }
      return;
    }
    my ($type, $path, $filepath) = parse_file_ref($args);
    $path and $filepath or do {
      $self->send("That isn't a valid file reference, see HELP FILEREF.");
      $self->send('Usage: "save <fileref>" to save or "save?" to check for unsaved files.');
      return;
    };
    if ($path !~ "^@{[$self->edit_zone]}") {
      $self->send("You don't have permission to save that zone.");
      return;
    }

    try {
      MLoaders::save_fileref($args);
      1;
    } catch {
      /Bad fileref type/ and $self->send("Sorry, I don't know how to save '$type'.") and return 0;
      die $_; # propagate
    } or return;
    
    $self->send('Okay.');
    mudlog "EDIT: " . $self->name . " saved $type:$path";
  },
},
'reload' => {
  requires => [qw(immortal)],
  code => sub {
    my ($self, $args) = @_;
    if (!$args) {
      $self->send('Reload what??');
    }
    my ($type, $path, $filepath) = parse_file_ref($args);
    $path and $filepath or do {
      $self->send("That isn't a valid file reference, see HELP FILEREF.");
      $self->send('Usage: &c;reload <fileref>&n;.');
      return;
    };
    if ($type eq 'mod') {
      $self->send("Use &c;mload&n; to reload modules.");
      return;
    }
    if ($path !~ "^@{[$self->edit_zone]}") {
      $self->send("You don't have permission to edit that zone.");
      return;
    }

    try {
      MLoaders::load_fileref($args);
      1;
    } catch {
      /Bad fileref type/ and $self->send("Sorry, I don't know how to load '$type'.") and return 0;
      die $_; # propagate
    } or return;
    
    $self->send('Okay.');
    mudlog "EDIT: " . $self->name . " reloaded $type:$path";
  },
},
#---------------------------------------------------------------------------------------------------
'zinf' => {
  requires => [qw(immortal)],
  code => sub {
    my ($self, $args) = @_;

    my ($zpath) = $args =~ s#^(/[\w/]+)\s*##;
    $zpath ||= ($self->container->roomname =~ m#^(.*)/[^/]+$#)[0];
    $zpath or do {
      $self->send('But what zone do you want to edit the info of?');
      return;
    };
    my $zone = MZone->by_path($zpath) or do {
      $self->send("No such zone: $zpath.");
      return;
    };

    my ($key, $value) = split /\s*=\s*|\s+/, $args, 2;
    
    $self->send("${zpath}'s $key: ".$zone->info($key))
      if $key;
    if ($key and $value) {
      $value !~ /~/ or do {
        $self->send("Zone info values can't contain tildes!");
        return;
      };
      $zone->info($key, $value);
      $self->send("Set to '$value'.");
    } elsif (!$key) {
      $self->send("Zone info for $zpath:");
      foreach my $ikey ($zone->info_keys) {
        $self->send(sprintf "&fc;%12s&n;: %s", $ikey, $zone->info($ikey));
      }
    }
  },
},
#---------------------------------------------------------------------------------------------------
'znew' => {
  requires => [qw(immortal CONTROLLER)],
  code => sub {
    my ($self, $args) = @_;

    $args or do {
      $self->send('Usage: znew <path of new zone>');
      return;
    };
    MZone->new($args);
    mudlog "EDIT: @{[$self->name]} created new zone '$args'";
    $::DirtyFiles{"zinf:$args"} = 1;
  },
},
#---------------------------------------------------------------------------------------------------

### Target Editing Commands #####################################################################################################

#---------------------------------------------------------------------------------------------------
'@select' => {
  requires => [qw(nonplayer)],
  basic => 1,
  code => sub {
    my ($self, $args) = @_;
    my $target;
    
    (my $silent) = $args =~ s/\s*(-s)\s*//;
    my $new = $args =~ s/^new\s+//;
    if ($args =~ m#^(/[\w/]+)$#) {
      $target = $1;
      my ($zone) = $target =~ m#^(.*)/[^/]+$#;
      if ($zone !~ ("^" . $self->edit_zone)) {
        $self->send('You do not have permission to edit that zone.');
        return;
      }
      if (not MObject->proto_exists($target)) {
        if ($new) {
          MObject->new_proto($target);
          $self->send("Created new object prototype $target.");
        } else {
          $self->send("That prototype doesn't exist.");
          return;
        }
      }
    } elsif ($args =~ m#^room(?:\s+(/[\w/]+))?$#) {
      my $rname = $1 || $self->container->roomname || do {
        $self->send('But what room do you want to select?');
        return;
      };
      my ($zone) = $rname =~ m#^(.*)/[^/]+$#;
      if ($zone !~ ("^" . $self->edit_zone)) {
        $self->send('You do not have permission to edit that zone.');
        return;
      }
      if (not exists $::Rooms{$rname}) {
        if ($new) {
          $::Rooms{$rname} = MObject->new('prototype' => ROOM_PROTO, 'roomname' => $rname);
          $self->send("Created new room $rname.");
        } else {
          $self->send("That room doesn't exist.");
          return;
        }
      }
      $target = $::Rooms{$rname}->id;
    } elsif ($args) {
      my $obj = $self->object_find($args, entire_world => 1);
      if (!$obj) {
        $self->send("No such object.");
        return;
      }
      if (!$self->unrestricted_edit and $obj) {
        $self->send("You can't modify existing objects without the unrestricted_edit flag.");
        return;
      }
      $target = $obj->id;
    }
    if (defined $target) {
      $self->edit_target($target);
      $self->send("Edit target selected.");
      if ($target =~ /^\d+$/) {
        MObject->by_id($target)->send("You feel as if something is watching you.");
      }
    }
    $self->edit_target_make_dirty() if $new;
    $self->do('@view') unless $silent;
  },
  help => <<'EOHELP',
@select [-s] thing
@select [-s] room
@select [-s] [new] /path/to/proto
@select [-s] [new] room /path/to/room

The &c;@select&n; command is used to select objects for editing. The argument can be any normal means of referring to an object, the pathname of a prototype, "room" to select the current room, or "room /whatever/path" to select another room.

If "new" is specified before the object, a new room or prototype will be created. You might find it useful to alias "@new" to "@select new".

The -s flag causes &c;@select&n; to not invoke &c;@view&n; after selecting the target.
EOHELP
},
#---------------------------------------------------------------------------------------------------
'@view' => {
  requires => [qw(nonplayer)],
  code => sub {
    my ($self, $args) = @_;
    my ($tname, $target);

    (my $norm) = $args =~ s/\s*(-a)\s*//;
    my $full = $args =~ s/^full\b//i;
    if ($args) {
      if ($args =~ m#^(/[\w/]+)$#) {
        my $pname = $1;
        my ($zone) = $pname =~ m#^(.*)/[^/]+$#;
        if (not MObject->proto_exists($pname)) {
          $self->send("That prototype doesn't exist.");
          return;
        }
        $target = MObject->obj_proto($pname);
      } elsif ($args =~ m#^r(?:o(?:om?)?)?\s+(/[\w/]+)$#) {
        my $rname = $1;
        my ($zone) = $rname =~ m#^(.*)/[^/]+$#;
        if (not exists $::Rooms{$rname}) {
          $self->send("That room doesn't exist.");
          return;
        }
        $target = $::Rooms{$rname}->id;
      } elsif ($args) {
        $target = $self->object_find($args, entire_world => 1);
        $target or do {
          $self->send("No such object.");
          return;
        };
      }
      $tname = ($target->id ? "#".$target->id : $args);
    } else {
      $target = $self->edit_target_obj;
      $tname = ($target->id ? "#".$target->id : $self->edit_target);
    }
    
    my @lines = ("($tname) " . $target->name . "'s fields:");
    foreach my $key (sort keys %$target) {
      next if !$full and (
              $key eq 'id'
           or $key eq 'command_queue'
           or $key eq 'commands_paused'
           or $key eq 'saveable');
      push @lines, sprintf "&fc;%12s&n;: %s", $key, $showsub->($target->{$key}, ($norm?'':$key));
    }
    $self->do_multicol(map {split /\n/, $_} @lines);
  },
  help => <<'EOHELP',
@view thing
@view /path/to/proto
@view room
@view room /path/to/room
@view

@view allows you to examine the fields of an object. Without an argument, it displays the currently selected object. With an argument (which is interpreted the same way as by @select), it displays that object, even if you do not have permission to select 


that object for editing.

@view performs the same function as 'stat' in CircleMUD.

The data structures are displayed in an almost-Perl syntax. Note that if a structure is surrounded in green parentheses, then it is being displayed in a way other than its actual structure. For example, the 'extra_descs' field displays as if it were a has


h with array references for keys. To disable all special formatting, provide the '-a' option.
EOHELP
},
#---------------------------------------------------------------------------------------------------
'@get' => {
  requires => [qw(nonplayer)],
  code => sub {
    my ($self, $key) = @_;
    my $obj = $self->edit_target_obj;
    
    (my $here) = $key =~ s/\s*(-h)\s*//;
    my $ob_name = $obj->name;
    $self->send($ob_name . "'s $key: " . $showsub->($obj->get_val($key), $key, heredoc => $here));
  },
  help => <<'EOHELP',
@get [-h] [-a] &g;<field>&n;

Displays the value of the named field in the same fashion as @view, following the prototype chain.
EOHELP
},
#---------------------------------------------------------------------------------------------------
'@set' => {
  requires => [qw(nonplayer)],
  code => sub {
    my ($self, $args) = @_;
    my $obj = $self->edit_target_obj;
    
    my ($key, $value) = split /\s*=\s*|\s+/, $args, 2;
    
    defined $value or do {
      $self->send("Set a field, sure, but to what?");
      return;
    };
    
    $value =~ s/^(['"])(.*)\1/$2/;
    
    my $fattrs = MObject->field_attrs($key);
    if ($fattrs) {
      if ($fattrs->{noset}) {
        $self->send("That field can't be set.");
        return;
      }
      if ($fattrs->{requires}) {
        foreach my $r (@{$fattrs->{requires}}) {
          next if $self->get_val($r);
          $self->send("You are not allowed to set $key because you don't have the $r flag.");
          return;
        }
      }

      if (ref($fattrs->{default}) eq 'ARRAY') { $value = [split /\s+/, $value]; }
      elsif (ref($fattrs->{default}) eq 'HASH') { $value = {map {$_, 1} split /,/, $value}; }
    } else {
      $self->send("Warning: $key is a non-standard field.");
    }

    my $ob_name = $obj->name;
    eval {
      $obj->set_val($key, $value, $self);
    };
    $@ and do {$self->send($@); return;};
    $self->send($ob_name . "'s $key set to " . $showsub->($obj->get_val($key), $_) . ".");

    $self->edit_target_make_dirty();
  },
  help => <<'EOHELP',
@set key value
@set key=value
@set key="value"

@set sets a field in the currently selected object.

Generally, the value is interpreted as a string. However, if the default value for a field is an array, then @set will automatically split the specified value on whitespace, and use that as the new field value.

Also, if the default value for a field is a hash, then @set will split the 

Some fields, like 'connection', 'ispc', and 'saveable', can't be set. Others, like 'affects' and 'has_slot', should not be set by this command, since their values are complex structures.
EOHELP
},
#---------------------------------------------------------------------------------------------------
'@clear' => {
  requires => [qw(nonplayer)],
  code => sub {
    my ($self, $key) = @_;
    my $obj = $self->edit_target_obj;
    
    my $fattrs = MObject->field_attrs($key);
    if ($fattrs->{noset}) {
      $self->send("That field can't be set.");
      return;
    }
    if ($fattrs->{requires}) {
      foreach my $r (@{$fattrs->{requires}}) {
        next if $self->get_val($r);
        $self->send("You are not allowed to set $key because you don't have the $r flag.");
        return;
      }
    }

    eval {
      $obj->reset_val($key, $self);
    };
    $@ and do {$self->send($@); return;};
    $self->send($obj->name . "'s $key deleted.");

    $self->edit_target_make_dirty();
  },
  help => <<'EOHELP',
@clear key

Deletes a field in the currently selected object, causing the value to be inherited from the object's prototype.
EOHELP
},
#---------------------------------------------------------------------------------------------------
'@delete' => {
  requires => [qw(nonplayer)],
  code => sub {
    my ($self) = @_;
    if (my $conf = $self->edit_delete_confirm) {
      if ($conf eq $self->edit_target) {
        my $obj = $self->edit_target_obj;
        if ($obj->roomname) {
          delete $::Rooms{$obj->roomname};
        }
        $obj->dispose;
        $self->send($conf . " deleted.");
      }
      $self->reset_val('edit_delete_confirm');
    } else {
      my $obj = $self->edit_target_obj; # assert valid target
      $self->edit_delete_confirm($self->edit_target);
      $self->send("Do you really want to delete @{[$self->edit_target]} (@{[$obj->name]})?\n".
                  "Type \@delete again to confirm.");
    }
  },
},
#---------------------------------------------------------------------------------------------------
((eval "use MIME::Base64 ()", $@) ? () : ('@freeze' => {
  requires => [qw(nonplayer)],
  code => sub {
    my ($self, $args) = @_;
    my $obj = $self->edit_target_obj;
    
    $self->send(<<"EOTHING");
Content-Type: application/octet-stream; name="@{[$obj->name]}_@{[$self->edit_target]}.obj"
Content-Transfer-Encoding: base64

@{[MIME::Base64::encode($obj->freeze)]}
EOTHING
  },
})),
#---------------------------------------------------------------------------------------------------
);

MObject->CommandAliases (
  '@view' => [qw(stat)],
  'save' => [qw(olc)],
);

MObject->ModMethods (
edit_target_obj => sub {
  my ($self) = @_;
  my $t = $self->edit_target;
  defined $t or do {
    die "CFAIL:No edit target selected.";
  };
  my $obj = $t =~ /^\d+$/ ? MObject->by_id($t) : MObject->obj_proto($t);
  defined $obj or do {
     $self->edit_target(undef);
    die "CFAIL:Edit target no longer exists.";
  };
  $obj;
},
edit_target_make_dirty => sub {
  my ($self) = @_;
  my $t = $self->edit_target;
  defined $t or return;
  my $isproto = $t !~ /^\d+$/;
  my ($zone, $type, $rn);
  if ($isproto) {
    ($zone) = $t =~ m#^(.*)/[^/]+$#;
    $type = 'obj';
  } elsif ($rn = MObject->by_id($t)->roomname) {
    ($zone) = $rn =~ m#^(.*)/[^/]+$#;
    $type = 'room';
  }
  return unless $type and $zone and !$::DirtyFiles{"$type:$zone"};
  mudlog "EDIT: " . $self->name . " edited " . ($isproto ? "prototype $t" : $rn ? "room $rn" : "[UNKNOWN]");
  $::DirtyFiles{"$type:$zone"} = 1;
},
);
