MObject->ModFields (
  exits => {default => {},},
  terrain => {default => 'city',},
  rideable => {default => 0,},
);

my %dir_opp = qw(
  north south
  west east
  up down
  northwest southeast
  southwest northeast
);
@dir_opp{values %dir_opp} = keys %dir_opp;
my %dir_name = qw(
  n north
  e east
  s south
  w west
  ne northeast
  se southeast
  sw southwest
  nw northwest
  u up
  above up
  d down
  below down
);
@dir_name{keys %dir_opp} = keys %dir_opp;
#mudlog Data::Dumper::Dumper(\%dir_name);
my $name_match = '(' . join('|', keys %dir_name) . ')';
my %exit_sort = qw(
  north 1
  northeast 2
  east 3
  southeast 4
  south 5
  southwest 6
  west 7
  northwest 8
  up 9
  down 10
);
my %terrain_move = qw(
  indoors .8
  city 1
  field 1.2
  forest 1.6
  hills 2.5
  mountain 5
  water_swim 10
  water_noswim 10
  underwater 2
  flying .5
);

MObject->ModMethods (

match_exit => sub { ################
  my ($self, $name) = @_;

  $name =~ s/\s*\b$name_match\b\s*//;
  my $dir = $1 ? $dir_name{$1} : '';

  #mudlog "DEBUG: m_e dir=$dir name=$name";
  if (!$name and !$dir) {
    die "CFAIL:What direction?";
  }

  my $cexits = $self->container->exits;
  return ($cexits->{$dir}, $dir) if $dir;

  foreach my $ename (keys %$cexits) {
    my $exit = $cexits->{$ename};
    if ($exit->{door} and $exit->{door} =~ /\b\Q$name\E\b/) {
      return ($exit, $ename);
    }
  }
  die "CFAIL:You don't see any '$name' here.";
},

move_direction_cmd => sub { ################
  my ($self, $dir) = @_;

  if (!$dir) {
    $self->send("Go in what direction?");
    return;
  }
  my $inside = $self->container;
  $inside or do {
    $self->send("Move? How?");
    return 0;
  };
  $dir = $self->match_exit($dir);

  if ($inside->rideable) {
    if (MLoaders->mloaded('body_pos') and !$inside->bp_can('move')) {
      $self->send($self->desc_gen('<i.name> is not in a suitable position for moving.', i => $inside));
      return;
    }
    $self->send($self->desc_gen("You command your <i.rootname> to move $dir.", i => $inside));
    return $inside->do("go $dir");
  }
  MLoaders->mloaded('body_pos') and $self->bp_assert('move', 'move around');
  return $self->move_direction($dir);
},
move_direction => sub { ################
  my ($self, $dir) = @_;

  my $inside = $self->container;  
    
  $inside or do {
    $self->send("Move? How?");
    return 0;
  };
  my $exit = $inside->exits->{$dir};
  $exit and $exit->{to} or do {
    $self->send("Alas, you cannot go $dir...");
    return 0;
  };

  $::Rooms{$exit->{to}} or do {
    mudlog("ERROR/WORLD: nonexistent room exit $exit->{to} at room @{[$self->container->roomname]}");
    $self->send('You try to go there, but a peculiar force prevents you.');
    return 0;
  };
  my $pts = .1 * $terrain_move{$inside->terrain || 'city'}; #FIXME

  if ($exit->{closed}) {
    $self->act("You try but bump your nose on $exit->{door}.",
               $self->name . " tries to go $dir but bumps $GENDER_POSS{$self->gender} nose on $exit->{door}.");
    return 0;
  }
  if ($self->m_move) {
    if ($pts > $self->c_move) {
      $self->send($self->desc_gen('<mov.name> <self.is?are:is> too tired.', mov => $self, self => $self));
      return 0;
    }
    $self->c_move($self->c_move - $pts);
  }
  return if grep !$_, call_hooks('roomexits_movement_ok', $self, $dir);

  $self->act("You leave $dir.", $self->name . " leaves $dir.");
  $self->move_into($::Rooms{$exit->{to}});
  $self->act(undef, $self->name . " has arrived @{[$self->dir_desc($self->opposite_dir($dir), 'from')]}.");
  $self->pause_commands($pts * 60);
  return 1;
},

opposite_dir => sub {
  return $dir_opp{$_[1]};
},

dir_desc => sub {
  my ($self, $dir, $type) = @_;
  if ($dir eq 'up') {
    return "up" if $type eq 'to';
    return "$type above";
  } elsif ($dir eq 'down') {
    return "down" if $type eq 'to';
    return "$type below";
  } else {
    return "$type the $dir";
  }
  
},

exits_look_str => sub {
  my ($self) = @_;
  my $estr = join(' ', map { my $e = $self->exits->{$_};
                             !$e->{to} ? () : $e->{closed} ? ($e->{minor} ? () : "&m;($_)&c;") : $_;
                           }
                           sort {($exit_sort{$a} || 0) <=> ($exit_sort{$b} || 0)}
                           keys %{$self->exits});
  return "&c;Exits: " . ($estr || 'None.') . "&n;\n";
},

);

MObject->CommandAliases (
  northeast => [qw(ne)],
  northwest => [qw(nw)],
  southeast => [qw(se)],
  southwest => [qw(sw)],
);

my $delay = 1;
MObject->Commands (
north     => {basic => 1, code => sub {$_[0]->move_direction_cmd('north')}},
northeast => {basic => 0, code => sub {$_[0]->move_direction_cmd('northeast')}},
east      => {basic => 1, code => sub {$_[0]->move_direction_cmd('east')}},
southeast => {basic => 0, code => sub {$_[0]->move_direction_cmd('southeast')}},
south     => {basic => 1, code => sub {$_[0]->move_direction_cmd('south')}},
southwest => {basic => 0, code => sub {$_[0]->move_direction_cmd('southwest')}},
west      => {basic => 1, code => sub {$_[0]->move_direction_cmd('west')}},
northwest => {basic => 0, code => sub {$_[0]->move_direction_cmd('northwest')}},
up        => {basic => 1, code => sub {$_[0]->move_direction_cmd('up')}},
down      => {basic => 1, code => sub {$_[0]->move_direction_cmd('down')}},
go        => {basic => 0, code => sub {$_[0]->move_direction_cmd($_[1])}},
  
'open' => {
  code => sub {
    my ($self, $args) = @_;
    MLoaders->mloaded('body_pos') and $self->bp_assert('reach_object', 'open things');

    if (!$args) {
      $self->send("Open what?");
      return;
    }

    my ($exit, $edir) = $self->match_exit($args);

    if ( $exit->{locked} ) {
      $self->send("Hmm...$exit->{door} seems to be locked.");
      return;
    }
    if ( !$exit->{closed} ) {
      $self->send("But $exit->{door}'s already open!");
      return;
    }
    $exit->{closed} = 0;
    $self->act("Okay.", $self->name . " opens $exit->{door}.");           

    my ($other_room, $other_exit);

    if ($other_room = $::Rooms{$exit->{to}} 
        and $other_exit = $other_room->exits->{MObject->opposite_dir($edir)}
        and $other_exit->{door}
        and $other_exit->{closed}
    ) {
      $other_exit->{closed} = 0;
      $other_room->echo_to_contents("$other_exit->{door} is opened from the other side.");
    }
    
  },
},
  
'close' => {
  code => sub {
    my ($self, $args) = @_;
    MLoaders->mloaded('body_pos') and $self->bp_assert('reach_object', 'close things');

    if (!$args) {
      $self->send("Close what?");
      return;
    }

    my ($exit, $edir) = $self->match_exit($args);
    $exit or return;

    if ( $exit->{closed} ) {
      $self->send("But $exit->{door}'s already closed!");
      return;
    }
    $exit->{closed} = 1;
    $self->act("Okay.", $self->name . " closes $exit->{door}.");           


    my ($other_room, $other_exit);

    if ($other_room = $::Rooms{$exit->{to}} 
        and $other_exit = $other_room->exits->{MObject->opposite_dir($edir)}
        and $other_exit->{door}
        and !$other_exit->{closed}
    ) {
      $other_exit->{closed} = 1;
      $other_room->echo_to_contents("$other_exit->{door} is closed from the other side.");
    }
    
  },
},
  
'@exit' => {
  requires => [qw(nonplayer)],
  code => sub {
    my ($self, $args) = @_;
    my $rev = not ($args =~ s/\s*(-r)\s*//);

    #print "entering \@exit\n";
    my ($dir, $command, $param) = split /\s+/, $args, 3;

    unless ($dir) {
      $self->send("Edit an exit, sure, but what exit?");
      return;
    }

    my $odir;
    unless (!$rev or $odir = MObject->opposite_dir($dir)) {
      $self->send("I don't know the opposite of $dir.");
      return;
    }

    #print "this room\n";
    my $this_room = $self->edit_target_obj;
    $this_room->localize_field('exits');
    my $this_exits = $this_room->exits;
    my $this_exit = $this_exits->{$dir};
    
    #print "other room\n";
    my ($other_room, $other_exits, $other_exit);
    if ($this_exit and $other_room = $::Rooms{$this_exit->{to}}) {
      #print "localizing\n";
      $other_room->localize_field('exits');
      #print "getting exits\n";
      $other_exits = $other_room->exits;
      #print "getting exit\n";
      $other_exit = $other_exits->{$odir} if $odir;
    }

    #print "after vars config\n";
    #$self->send("debug: other_room id = $other_room->{id}");
    #$self->send("rev mode is $rev");

    if ($this_room->roomname !~ m#^@{[$self->edit_zone]}#) {
      $self->send("You do not have permission to edit this zone.");
      return;
    }

    if ($rev and $other_room and $other_room->roomname !~ m#^@{[$self->edit_zone]}#) {
      $self->send("You do not have permission to edit the other zone.");
      return;
    }
    
    if (!$command) {
      $self->send("But what do you want to do there? (Usage: \@exit dir command [param])");
      return;
    } 

    if ($command ne 'to' and not $this_exit) {
      $self->send("But there's no exit $dir to edit! (Maybe you should make one.)");
      return;
    }

    if ($command eq 'delete' or $command eq 'purge') {
      delete $this_exits->{$dir};
      delete $other_exits->{$odir} if $rev;
      $self->send("\u$dir exit deleted.");
      
    } elsif ($command eq 'to' or $command =~ m#^/#) {
      $param = $command if $command ne 'to';
      if (!$::Rooms{$param}) {
        $self->send("$param does not exist.");
        return;
      }
      $other_room = $::Rooms{$param};
      if (!$this_exit) {
        $this_exits->{$dir}   = {to => $param};
        $other_room->exits->{$odir} = {to => $this_room->roomname} if $rev;
        $self->send("$dir exit created to $param.");
      } else {
        #print "in redirect\n";
        $other_room->localize_field('exits');
        $other_exits = $other_room->exits;
        $other_exit = $other_exits->{$odir} if $odir;
        $this_exit->{to} = $param;
        $other_exit->{to} = $this_room->roomname if $rev and $other_exit;
        $self->send("$dir exit redirected to $param.");
        $self->send("You might want to change the exit description.") if $this_exit->{desc};
        #print "after redirect\n";
      }

    } elsif ($command eq 'desc') {
      $this_exit->{desc} = $param;
      $other_exit->{desc} = $param if $rev;
      $self->send("Description set.");

    } elsif ($command eq 'door') {
      $this_exit->{door} = $param;
      $other_exit->{door} = $param if $rev;
      $self->send("Door '$param' created.");

    } elsif ($command eq 'key') {
      $this_exit->{door} or do {
        $self->send("But there's no door!");
        return;
      };
      $this_exit->{key} = $param;
      $other_exit->{key} = $param if $rev;
      $self->send("Key set.");

    } elsif ($command eq 'pick') {
      $this_exit->{door} or do {
        $self->send("But there's no door!");
        return;
      };
      $this_exit->{pick_difficulty} = $param;
      $other_exit->{pick_difficulty} = $param if $rev;
      $self->send("Pick difficulty set.");

    } elsif ($command eq 'open') {
      delete $this_exit->{door};
      delete $this_exit->{closed};
      delete $this_exit->{locked};
      delete $this_exit->{pickproof};
      delete $this_exit->{key};
      if ($rev) {
        delete $other_exit->{door};
        delete $other_exit->{closed};
        delete $other_exit->{locked};
        delete $other_exit->{pickproof};
        delete $other_exit->{key};
      }
      $self->send("Door removed.");
    } else {
      $self->send("Sorry, but I don't know what '$command' means.");
      return;
    }

    if ($other_room and $rev) {
      my ($zone) = $other_room->roomname =~ m#^(.*)/[^/]+$#;
      $::DirtyFiles{"room:$zone"} = 1;
    }
    my ($zone) = $this_room->roomname =~ m#^(.*)/[^/]+$#;
    $::DirtyFiles{"room:$zone"} = 1;
  },
  help => <<'EOHELP',
@exit [-r] &g<direction>&n &g<command>&n &g<param>&n

The &y;exit&n command is used for creating, deleting, and modifying room exits.

The -r switch tells it not to do matching operations on the opposing exit (the exit in the opposite direction in the room this exit leads to).

&c;Creating Exits&n

exit east /test/center
exit east to /test/center

will create an exit east from the currently selected object, connecting to the room /test/center, and an exit west from the room /test/center, connecting to the currently selected object (if it is a room).

&c;Deleting Exits&n

exit north delete
exit north purge

will remove the exit in the specified direction, and the opposing exit.

&c;Description&n

@exit east desc <description>
will add a description to the exit.

&c;Doors&n

exit east door <name>
will create a door for the given exit. <name> should be the name of the door.

exit east open
will remove the door (and key information) on the exit.

exit east key <proto>
sets the object required to unlock the door.

exit east pick <difficulty>
sets the difficulty of picking the lock on the door. 0 is 'very easy' and 1 is completely impossible.
EOHELP
},
);

MLoaders->Hooks(
look_inside_extra_info => sub {
  my ($self, $viewer) = @_;
  return $viewer->can_see($self) ? $self->exits_look_str : ();
},
);

1;