Require 'containment';

Define Fields => {
  body_pos => {default => 'standing'},
  has_body_pos => {default => 0},
};

my %bp_can = (
  floating => {map+($_,1),qw(
    fly
    fight
    sit
    sleep
    reach_object
    reach_inventory
    move
    look
    hear
  )},
  standing => {map+($_,1),qw(
    fight
    sit
    sleep
    reach_object
    reach_inventory
    move
    look
    hear
  )},
  sitting => {map+($_,1),qw(
    stand
    sleep
    reach_object
    reach_inventory
    look
    hear
  )},
  sleeping => {map+($_,1),qw(
    wake
  )},
  stunned => {map+($_,1),qw(
    look
    hear
  )},
  unconscious => {map+($_,1),qw(
  )},
  dying => {map+($_,1),qw(
  )},
);
my %bp_gain = qw(
  floating 1
  standing 1
  swimming 0.9
  
  sitting 1.6
  sleeping 3.4
  
  stunned 0.33
  unconscious 0.2
  dying -1
);

my %bp_desc = (
  floating => 'floating',
  standing => 'standing',
  sitting => 'sitting',
  sleeping => 'sleeping',
  stunned => 'lying stunned',
  unconscious => 'lying unconscious',
  dying => 'dying',
);

Define Methods => {
bp_can => sub {
  my ($self, $action) = @_;
  return $self->has_body_pos ? ($bp_can{$self->body_pos} || {} )->{$action} : 1;
},
bp_assert => sub {
  my ($self, $action, $adesc) = @_;
  my $bp = $self->body_pos;
  unless (!$bp or ($bp_can{$bp} || {} )->{$action} ) {
    if ($bp eq 'sleeping') {
      die 'CFAIL:In your dreams, or what?';
    } elsif ($bp_can{standing}{$action}) {
      TransContext('connection')->cmd_execute($self, 'stand', '');
    } else {
      die "CFAIL:You can't ".($adesc || 'do that')." while you're $bp.";
    }
  }
  return 1;
},
bp_desc => sub {
  my ($self) = @_;
  return $bp_desc{$self->body_pos} || $self->body_pos;
},
do_stun => sub {
  my ($self, $stime) = @_;
  
  $self->nact('<self.vis?<self> <v:is> stunned!>');
  $self->body_pos('stunned');
  MEvent::Message->new(
    name => 'Recover from Stun',
    'time' => $stime,
    owner => $self,
    target => $self,
    method => 'stun_recover',
  );
},
stun_recover => sub {
  my ($self) = @_;
  return unless $self->body_pos eq 'stunned'.
  $self->body_pos('sitting');
  $self->nact('<self.vis?<self> <v:recovers>.>');
},
};

Define Hooks => {
recovery_modifier => sub {
  my ($self) = @_;
  if (!exists $bp_gain{$self->body_pos}) {
    mudlog "ERROR/WORLD: no gain value for body position '@{[$self->body_pos]}'.";
    return;
  }
  return $bp_gain{$self->body_pos};
},

object_description_complements => sub {
  my ($self) = @_;
  return $self->has_body_pos ? [$self->bp_desc] : ();
},
};

my $set_pos = sub {
  my ($self, $into, $pos, $pverb, $pdnorm, $pdon) = @_;
  $self->bp_assert($pverb, $pverb);
  
  if ($into) { 
    $into->can_contain($self) or die "CFAIL:There's no room for you ".$into->enter_prep." ".$into->name.".";
    $self->body_pos($pos);
    $self->nact($pdon, target => $into);
    $self->move_into($into);
  } else {
    $self->body_pos($pos);
    $self->nact($pdnorm);
  }
};

my $pos_cmd = sub {
  my ($pos, $pverb, $pdnorm, $pdon) = @_;
  for ($pdnorm, $pdon) {
    $_ =~ s/(.*)/<self.vis?$1>/;
  }
  return sub {
    my ($self, $args) = @_;
    
    my $into;
    if ($args) {
      $into = $self->object_find($args, no_self_contents => 1);
    } else {
      OFIND: {
        my @search = grep {$_->can_contain($self) and $self->can_see($_) and $_->getAttr("for_$pos")} @{$self->container->contents};
        foreach (@search) {
          next if @{$_->contents};
          $into = $_; last OFIND;
        }
        $into = $search[0];
      }
    }
    $set_pos->($self, $into, $pos, $pverb, $pdnorm, $pdon);
  };
};

Define Commands => {
  stand => {code => sub {
    my ($self) = @_;
    $self->bp_assert('stand', 'stand');
    my $oldpos = $self->body_pos;
    $self->body_pos('standing');
    my $cont = $self->container;
    if ($cont->getAttr("for_$oldpos")) {
      my $exit_prep = 'out of';
      $exit_prep = 'off' if $cont->enter_prep eq 'on';
      $self->nact("<self.vis?<self> <v:gets> $exit_prep <cont> and <v:self:stands> up.>", cont => $cont);
      $self->move_into($cont->container);
    } else {
      $self->nact('<self.vis?<self> <v:stands> up.>');
    }
  }, junk_prefixes => ['on'],
  },
  sit => {aliases => [qw(mount ride)], code => $pos_cmd->('sitting', 'sit', '<self> <v:sits> down.', '<self> <v:sits> down <target.prep> <target>.'), junk_prefixes => ['down on', qw(down on)]},
  'sleep' => {code => $pos_cmd->('sleeping', 'sleep', '<self> <v:lies> down and <v:falls> asleep.', '<self> <v:lies> down on <target> and <v:self:falls> asleep.'), junk_prefixes => [qw(on)]},
  # add snoring
  wake => {aliases => [qw(awaken)], code => sub {
    my ($self) = @_;
    $self->bp_assert('wake', 'wake up');
    $self->body_pos('sitting');
    $self->nact('<self> <v:wakes> up.');
  }},
};


