Require 'commands';

my %att = (nolist => 1, no_object => 1, code => 'sub:othermud_command_msg');

Define Commands => {
  at => {%att,privileges=>['watcher'],msg=>'you must go to the location yourself.'},
  advance => {%att,privileges=>['watcher'],msg=>'there are no such things as levels.'},
  balance => {%att},
  buy => {%att,msg=>'try talking instead.'},
  check => {%att,msg=>'try talking instead.'},
  compact => {%att,msg=>'isn\'t this compact enough?'},
  credits => {%att,msg=>'use "help credits" instead.'},
  deposit => {%att},
  #display => {%att,msg=>'use "prompt" instead.'},
  donate => {%att,msg=>'you\'ll have to do that yourself.'},
  force => {%att,privileges=>['watcher']},
  freeze => {%att,privileges=>['watcher']},
  gold => {%att,msg=>'just "look" for it.'},
  holylight => {%att,privileges=>['watcher']},
  junk => {%att},
  last => {%att,msg=>'use "wrecent" instead.'},
  levels => {%att,msg=>'levels? What levels?'},
  mail => {%att},
  news => {%att,msg=>'use "help news" instead.'},
  nohassle => {%att,privileges=>['watcher']},
  olc => {%att,privileges=>['watcher'],msg=>'use the @ commands instead.'},
  pardon => {%att,privileges=>['watcher']},
  policy => {%att,msg=>'use "help" instead.'},
  practice => {%att,msg=>'just do it!'},
  qecho => {%att},
  quest => {%att},
  receive => {%att},
  rent => {%att},
  return => {%att,privileges=>['watcher'],msg=>'use "detach" and "attach" instead.'},
  roomflags => {%att,privileges=>['watcher']},
  sell => {%att,msg=>'try talking instead.'},
  split => {%att,msg=>'you have to do that yourself.'},
  switch => {%att,privileges=>['watcher'],msg=>'use "attach" instead.'},
  syslog => {%att,privileges=>['watcher'],msg=>'use "cpref log" instead.'},
  thaw => {%att,privileges=>['watcher']},
  track => {%att},
  trackthru => {%att,privileges=>['watcher']},
  value => {%att,msg=>'try talking instead.'},
  vnum => {%att,privileges=>['watcher']},
  vstat => {%att,privileges=>['watcher'],msg=>'use @view instead.'},
  weather => {%att,msg=>'just "look".'},
  where => {%att},
  withdraw => {%att,msg=>'try talking instead.'},
  zreset => {%att,privileges=>['watcher'],msg=>'we don\'t even have zones!'},
  

  # multi-name cmds
  bug => {%att,aliases=>[qw(idea typo)],msg=>'use "report" instead.'},
  gossip => {%att,aliases=>[qw(auction grats qsay)],msg=>'use "chat" instead.'},
  gsay => {%att,aliases=>[qw(gtell)],msg=>'try shouting instead.'},
  nogossip => {%att,aliases=>[qw(noauction nograts)],msg=>'use "cpref chat off" instead.'},
};

Define Subs => {
'othermud_command_msg' => sub {
  my ($con, $obj, $cmd, $args, %info) = @_;
  my $altmsg = MDefList->path("/Commands/$cmd")->{msg};
  return [error=>{}, "$::Config{'name'} has no \"$info{verb}\" command" . ($altmsg ? "; $altmsg" : '.')];
},
};