Define Hooks => {

prompt_info => sub {
  my ($self, $con) = @_;
  return $con->user && $con->user->privileged('watcher') ? '*P*' : ();
},

mudlog => sub {
  my ($str) = @_;
  if (eval {MConnection->initialized}) {
    (my $single = $str) =~ s#\s*\n\s*(\S)# / $1#g;

    my $sx = ['log'=>{'xml:space'=>'preserve', ($str =~ /^(ERROR|WARNING:)/ ? (type => 'error'): ())}, "[ $single ]"];
    for (all MConnection) {
      $_ and $_->open and $_->pref('mudlog') and $_->send($sx);
    }
  }
},

};

Define Subs => {
'sx_dump_thingy' => sub {
  my ($val, %opt) = @_;
  my @nval;
  if (!defined $val) {
    @nval = [quo=>{}, 'undef'];
  } elsif (ref $val) {
    if (ref $val eq 'ARRAY') {
      @nval = ([quo=>{}, '['], (map +([quo=>{}, ", "], sx_dump_thingy($_)), @$val), [quo=>{}, ']']);
      splice @nval, 1, 1 if @nval > 2;
    } elsif (ref $val eq 'HASH') {
      @nval = ([quo=>{}, '{'], (map {[key=>{}, $_], [quo=>{}, ": "], sx_dump_thingy($val->{$_}), ", "} keys %$val), [quo=>{}, '}']);
      splice @nval, -2, 1 if @nval > 2;
    } elsif (ref $val eq 'SCALAR' or ref $val eq 'REF') {
      @nval = ([quo=>{}, '\\'], sx_dump_thingy($$val));
    } elsif (ref $val eq 'CODE') {
      @nval = "$val";
    } elsif (ref $val eq 'GLOB') {
      @nval = [quo=>{}, 'GLOB'];
    } elsif (blessed($val, 'MObjectRef')) {
      @nval = $val->ref_exists
              ? [obj=>{part=>'idn'}, $val]
              : ([quo=>{}, '#'], $val->id, ' ', [quo=>{}, 'STALE']);
    } elsif (blessed($val, 'MConnection')) {
      @nval = ([quo=>{}, 'Connection #'], $val->id);
    } else {
      @nval = ([quo=>{}, '<'], ref($val), [quo=>{}, '>']);
    }
  } elsif ((0 and $val =~ /\n|.{80}/) or $opt{heredoc}) {
    $val = "<<'%%END%%'\n$val\n%%END%%";
    @nval = $val;
  } else {
    my $chopped;
    $val =~ s/^(.{128}|[^\cJ]+\cJ).+/$1/s and $chopped = 1 unless $opt{get};
    @nval = $val =~ m#^[-+]?[\w/.]+$# ? $val : ([quo=>{}, "'"], $val, [quo=>{}, $chopped ? "...'" : "'"]);
  }
  return [group=>{}, @nval];
},
};

Define Commands => {
#---------------------------------------------------------------------------------------------------
'mload' => {
  requires => [qw(controller)],
  no_object => 1,
  code => sub {
    my ($con, $args) = @_;
    $args or die "CFAIL:Usage: mload <mpMUD module name>";
    mudlog "(PC) ".$con->user->name." loads module $args";
    MModules->unload_module($args);
    MModules->load_module($args);
    return;
  },
  help => <<'EOHELP',
mload &:meta<mpMUD module name>&:n

Loads or reloads a mpMUD module.
EOHELP
},
#---------------------------------------------------------------------------------------------------
'munload' => {
  requires => [qw(controller)],
  no_object => 1,
  code => sub {
    my ($con, $args) = @_;
    $args or die "CFAIL:Usage: munload <mpMUD module name>";
    mudlog "(PC) ".$con->user->name." unloads module $args";
    MModules->unload_module($args);
    return;
  },
  help => <<'EOHELP',
mload &:meta<mpMUD module name>&:n

Unloads a mpMUD module. 
EOHELP
},
#---------------------------------------------------------------------------------------------------
};