Require 'containment';

Define Fields => {
  cnt_maxweight => {default => -1},
  cnt_wfail_msg => {default => '<self.vis?<self> <v:breaks> due to <self.ppron> load!:<viewer> <v:hears> a loud cracking sound!>'},
  cnt_wfail_type => {default => 'pieces'},
  cnt_wwarn_msg => {default => '<self.aud?<self> <v:creaks> under <self.ppron> load.>'},
};

Define Hooks => {
'i_change' => sub {
  my ($self, $info) = @_;
  
  #mudlog "DEBUG: in i_change by $info->{weight} for ".$self->name;
  return if $info->{weight} <= 0;
  return if $self->cnt_maxweight < 0;
  my $weight = $self->i_weight;
  return unless $weight > $self->cnt_maxweight * .80;
  if ($weight > $self->cnt_maxweight) {
    $self->nact($self->cnt_wfail_msg);
    &{{
      'pieces' => sub {
        #mudlog "DEBUG: in pieces routine";
        my $pcs = MObject->new(
          article => 'the',
          enter_prep => 'among',
          name => "broken pieces of " . $self->nphr,
          invisible => $self->invisible,
          weight => $self->weight,
          density => $self->density / 2,
          glance_contents => 1,
          gender => 'plural',
          cnt_type => 'open',
        );
        $self->container->add_contents($pcs);
        $pcs->add_contents(@{$self->contents});
        $self->destroy;
      },
      'drop' => sub {
        while ($self->i_weight > $self->cnt_maxweight) {
          my $obj = ($self->contents or last)->[-1] or last;
          $self->nact('<self> drop<self!s> <obj>.', obj => $obj);
          $obj->move_into($self->container);
        }
      },
    }->{$self->cnt_wfail_type} || sub {mudlog "#".$self->id." has bad weight fail type!"}};
  } else {
    $self->nact($self->cnt_wwarn_msg);
  }
},
};

