MObject->new(
  article => 'a',
  cnt_closed => 1,
  cnt_inside_open => 0,
  cnt_type => 'open',
  comment => 'Room prototype. All rooms should inherit from this.',
  idesc => 'You are in an unfinished room.',
  name => 'room',
  sky_vis => 1,
)->addName('Proom')->lock;

MObject->new(
  comment => 'Used by destroy.',
  decay_msg => '<self> blows away in a slight breeze.',
  decay_time => 60,
  name => 'pile of ashes',
  name_plural => 'piles of ashes',
  ldesc => 'A small pile of black ashes. They are very coarse, as if whatever produced them burned rapidly',
  weight => 0.001,
)->addName('Pashes')->lock;

MObject->new(
  'prototype' => 'Proom',
  article => 'The',
  name => 'Beginning',
  idesc => '<self.vis?Infinite nothingness. Smooth gray surface below, empty dull-blue sky above.><self.aud? Silence, complete silence.>..',
  location => [0,0,0],
)->addName('Rstart');

MObject->new(
  'name' => 'chair',
   cnt_type => 'open',
   cnt_interior => 1000,
   enter_prep => 'on',
   for_sitting => 1,
   glance_contents => 1,
   weight => 11,
)->addName('Pchair')->lock;

MObject->new(
  'm_hit' => 100,
  'm_move' => 100,
  'c_hit' => 100,
  'c_move' => 100,
  'name' => '<generic creature>',
  'comment' => 'Use this to inherit attributes of basic "aliveness".',
  'has_metabolism' => 1,
  enter_prep => 'on',
  cnt_type => 'open',
  voluntary_carry => 1,
  cnt_wfail_msg => '<self> tr<self?y:ies> to carry too much!',
  cnt_wfail_type => 'drop',
  cnt_wwarn_msg => '<self> strain<self!s> under <self.ppron> load.',
)->addName('Palive')->lock;

MObject->new(
  'prototype' => 'Palive',
  name => 'humanoid',
  weight => 180,
  density => 0.9,
  has_body_pos => 1,
  can_speak => 1,
  allow_genders => {female => 1, male => 1},
  cnt_interior => 1000,
)->addName('PspcHumanoid')->lock;

MObject->new(
  'prototype' => 'PspcHumanoid',
  'name' => 'human being',
  ldesc => 'A very ordinary-looking person.',
)->addName('PspcHuman')->lock;

MObject->new(
  'prototype' => 'Palive',
  rideable => 1,
  for_sitting => 1,
  allow_genders => {female => 1, male => 1},
)->addName('PspcHerbivore')->lock;

MObject->new(
  'prototype' => 'PspcHerbivore',
  'name' => 'horse',
  glance_contents => 1,
  weight => 800,
  interior => 800,
)->addName('PspcHorse')->lock;

my $owner = MUser->new('Owner');
$owner->set(privileges => {map {$_, 1} qw(watcher builder runner controller)});

1;
