package MEvent::Message;
use strict;

use vars qw(@ISA);
use MEvent;
@ISA = qw(MEvent);

use MCoreTools;

sub new {
  my ($class, %param) = @_;
  
  my $self = $class->SUPER::new(%param);
  
  $self->{method} = $param{method} or croak "No method specified";
  my $targ = $self->{target} = $param{target} or croak "No message specified";
  if (ref $targ) {
    if (ref $targ eq 'MObject') {
      $targ = $targ->as_ref;
    } elsif (ref $targ ne 'MObjectRef' and !$self->{no_store}) {
      croak "Target must be package or MObjectRef unless event is no_store";
    }
  }
  $self->{arguments} = $param{arguments} || [];
  
  $self;
}

sub run {
  my ($self) = @_;
  
  $self->SUPER::run();

  # it's not our job to catch exceptions...
  
  my $m = $self->{method};
  local $Carp::CarpLevel = $Carp::CarpLevel + 1;
  $self->{target}->$m(@{$self->{arguments}}); # should be void context
  1;
}

sub description {
  (ref($_[0]{target}) ? '[' . ref($_[0]{target}) . ']' : $_[0]{target}) . '->' . $_[0]{method} . '(' . join(', ', map ref() ? '['.ref($_).']' : $_, @{$_[0]{arguments}}) . ')';
}