package MInitializable;
use strict;
use vars qw();
use MCoreTools;

sub initialize {
  my ($class) = @_;
  no strict 'refs';
  my $flag = \${"${class}::_initialized"};
  return unless grep $_ eq __PACKAGE__, @{"${class}::ISA"};
  return if $$flag;
  mudlog "Initializing $class..." if $::Config{verbose_startup};
  mudlog_indent if $::Config{verbose_startup};
  $$flag = 1;
  $class->_initialize;
  mudlog_outdent if $::Config{verbose_startup};
}

sub initialized {
  my ($class) = @_;
  no strict 'refs';
  return ${"${class}::_initialized"};
}

sub _initialize {}

1;
