package Mud::Proxy::Key;
use strict;
use Mud::CoreTools;
use Mud::Proxy;
use vars qw(@ISA);
@ISA = qw(Mud::Proxy);

=head1 Description

Mud::Proxy::Key implements a proxy that refers to objects by storage access
keys.

=head1 Methods

=cut

###  #####################################

=item CM new(STORAGE_TAG, STORAGE_KEY)

As described in Mud::Proxy, with two arguments.

=cut

sub new {
  my ($class, $tag, $key) = @_;
  my $self = $class->SUPER::new;
  $self->{tag} = $tag;
  $self->{key} = $key;
  return $self;
}

# No documented variation
sub proxy_real_obj {
  my ($self) = @_;
  Mud::Storage->storage($self->{tag})->real_obj($self->{key})
    or croak "Object <? $self->{tag} $self->{key}> does not exist, died"; # FIXME:Exception
}

# No documented variation
sub proxy_exists {
  my ($self) = @_;
  return Mud::Storage->storage($self->{tag})->real_obj($self->{key}) ? 1 : undef;
}

1;
__END__
