package Mud::Storage::Ephemeral;
use strict;
use Mud::CoreTools;
use Mud::Storage;
use vars qw(@ISA $NextID);
@ISA = qw(Mud::Storage);

$NextID ||= 1;

=head1 Description

Mud::Storage::Ephemeral is a storage object which does not persist
objects.

=cut

### Initialization ########################################

__PACKAGE__->register_storage('temp');
__PACKAGE__->register_storage('eph');

### Methods #############################################################

=head1 Methods

=over 4

=cut

sub real_obj {
  my ($self, $key) = @_;
  return ($self->cache_get($key, 1));
}

sub object_register {
  my ($self, $obj, $key) = @_;
  $key ||= $NextID++;
  $obj->storage_set_cookie($key);
  $self->cache_add($key, $obj);
}

sub object_unregister {
  my ($self, $obj) = @_;
  $self->cache_remove($obj->storage_get_cookie);
}

sub object_get_key {
  my ($self, $obj) = @_;
  return $obj->storage_get_cookie;
}

sub object_changed {
  #my ($self, $obj) = @_;
}

=back

=cut

1;
__END__