my $showsub;
$showsub = sub {
  my ($val, $field) = @_;
  $field ||= '';
  my $nval;
  if (!defined $val) {
    $nval = '&y;undef&n;';
  } elsif (ref $val) {
    if (ref $val eq 'ARRAY') {
      $nval = "&y;[&n;" . (join '&y;, &n;', map {$showsub->($_)} @$val) . "&y;]&n;";
    } elsif (ref $val eq 'HASH') {
      if ($field eq 'exits') {
        $nval = "&y;{&n;\n   " . (join "&y;,\n   &n;", map {"&c;$_&n: " . $showsub->($val->{$_}, "exitrec")} keys %$val) . "&y;}&n;";
      } elsif ($field eq 'exitrec') {
        $nval = "&y;{&n;" . (join '&y;, &n;', map {"&c;$_&n: " . $showsub->($val->{$_}, "exitfield_$_")} grep defined($val->{$_}) && ($_ ne 'dir'), keys %$val) . "&y;}&n;";
      } else {
        $nval = "&y;{&n;" . (join '&y;, &n;', map {"&c;$_&n: " . $showsub->($val->{$_})} keys %$val) . "&y;}&n;";
      }
    } elsif (ref $val eq 'MObject') {
      $nval = "&y;OBJECT{&n;" . $val->vistype . ": " . $val->name . "&y;}&n;";
    } elsif (ref $val eq 'MConnection') {
      $nval = "&y;CONNECTION{&n;" . $val->ip . ":" . $val->port . "&y;}&n;";
    }
  } elsif ($field eq 'exitfield_flags') {
    $nval = sprint_flags($val, \@EXITFLAGS) || '';
  } elsif ($field eq 'roomflags') {
    $nval = sprint_flags($val, \@ROOMFLAGS);
  } elsif ($field eq 'flags') {
    $nval = sprint_flags($val, \@OBJECTFLAGS);
  } elsif ($val !~ /^-?[\w\/]+$/) {
    $nval = $val;
    $nval =~ s/'/\\'/;
    $nval = ($field eq 'ldesc' ? "\n" : '') . qq{'$nval'};
  } else {
    $nval = $val;
  }
  $nval;
};

my %fieldtab = (
  'prototype' => 'PASS',
  comment => 'PASS',
  id => 'DENY',
  container => 'DENY',
  interp => 'DENY',
  contents => 'DENY',
  connection => 'DENY',
  aliases => 'PASS',
  vistype => 'PASS',
  flags => sub {parse_flags(uc $_[0], \%OBJECTFLAGS)},
  name => 'PASS',
  sdesc => 'PASS',
  ldesc => 'PASS',
  idesc => 'PASS',
  c_hit => 'PASS',
  m_hit => 'PASS',
  c_move => 'PASS',
  m_move => 'PASS',
  weight => 'PASS',
  volume => 'PASS',
  inside => 'PASS',
  level => sub {
    my ($v, $o) = @_;
    $v = 1 if $v < 1;
    $v = 30 if $v > 30;
    $v;
  },
  ac => 'PASS',
  'exp' => 'PASS',
  deaths => 'PASS',
  ispc => 'DENY',
  saveable => 'DENY',
  myzone => 'PASS_33',
  title => 'PASS',
  class => 'TDENY',
  gender => 'PASS',
  position => 'PASS',
  sdesc_pos => 'PASS',
  fighting => 'DENY',
  otype => 'PASS',
  food_value => 'PASS',
  exits => 'TDENY',
  roomflags => sub {parse_flags(uc $_[0], \%ROOMFLAGS)},
  terrain => 'PASS',
  roomname => 'TDENY',
  food => 'PASS',
  water => 'PASS',
  drunk => 'PASS',
  str => 'PASS',
  'int' => 'PASS',
  wis => 'PASS',
  dex => 'PASS',
  con => 'PASS',
  cha => 'PASS',
);

if ($args) {
  my ($target, $field, $value) = split /\s+|\s*[.=]\s*/, $args, 3;
  $value =~ s/^(['"])(.*)\1/$2/ if defined $value;
  my ($obj, $reftype, $zone);
  if ($target =~ m#^(/[\w/]+)$#) {
    $reftype = 'proto';
    my $oname = $1;
    ($zone) = $target =~ m#^(.*)/[^/]+$#;
    $obj = $MObject::Prototypes{$oname};
    if (not $obj and defined $value) {
      $obj = $MObject::Prototypes{$oname} = MObject->new_proto;
      $self->send("Created new object prototype $oname.");
    }
    if ($value and $self->level < 33 and $zone !~ "^$self->myzone" and defined $value) {
      $self->send('You do not have permission to edit that zone.');
      return;
    }
  } elsif ($target eq 'r') {
    $reftype = 'object';
    $obj = $self->container;
    if (defined $obj->roomname) {
      ($zone) = $obj->roomname =~ m#^(.*)/[^/]+$#;
      if ($value and $self->level < 33 and $zone !~ "^@{[$self->myzone]}") {
        $self->send('You do not have permission to edit that zone.');
        return;
      }
    } else {
      if ($self->level < 33) {
        $self->send("You can't modify existing objects unless you're at least level 33.");
        return;
      }
    }
  } else {
    $reftype = 'object';
    $obj = $self->get_any_object($target);
    if ($self->level < 33 and defined $value) {
      $self->send("You can't modify existing objects unless you're at least level 33.");
      return;
    }
  }
  if ($obj) {
    if ($field and $field eq 'DELETE') {
      if ($reftype eq 'proto') {
        $target =~ /^[\w\/]+$/;
        my $oname = $1;
        delete $MObject::Prototypes{$oname};
        $self->send("Deleted object prototype $oname.");
        $::DirtyFiles{"obj:$zone"} = 1;
      } elsif ($reftype eq 'object' and $obj->container) {
        $obj->dispose;
        $self->send("Destroyed object.");
      } elsif ($reftype eq 'object' and !$obj->container) {
        my $rn = $obj->roomname;
        $obj->dispose;
        delete $::Rooms{$rn};
        $self->send("Deleted room $rn.");
        $::DirtyFiles{"room:$zone"} = 1;
      } else {
        $self->send("Internal error in @.");
      }
    } elsif ($field) { 
      $obj->set_interp_type if $field eq 'vistype';
      my $val = eval {$obj->$field()};
      unless ($@) {
        $self->send(ucfirst $obj->name . "'s $field: " . $showsub->($val, $_));
      } else {
        $self->send(ucfirst $obj->name . " doesn't have $field.");
        return;
      }
      if (defined $value) {
        my $set = $fieldtab{$field};
        if (!defined($set)) {
          $self->send('Missing permissions table entry, sorry.');
        } elsif ($set =~ /^PASS/ or ref $set eq 'CODE') {
          if ($set =~ /^PASS_(\d+)$/ and ($1 > $self->level or !$self->ispc)) {
            $self->send("You aren't a high enough level to set that.");
            return;
          }
          if ($value eq 'DELETE') {
            delete $obj->{$field}; # should be changed
            $self->send("'$field' deleted.");
          } else {
            if (ref $set) { $obj->$field($set->($value), $obj, $self) }
            else          { $obj->$field($value)                      }
            $self->send("Set to " . $showsub->($obj->$field(), $_) . ".");
            syslog "EDIT: @{[$self->name]} changed $target.";
          }
          if ($reftype eq 'proto') {$::DirtyFiles{"obj:$zone"} = 1 if defined $zone}
          elsif (!$obj->container) {$::DirtyFiles{"room:$zone"} = 1}
          
        } elsif ($set eq 'DENY') {
          $self->send("You can't set that directly.");
        } elsif ($set eq 'TDENY') {
          $self->send("Sorry, I don't know how to set that yet.");
        } else {
          $self->send('Bad permissions table entry, sorry.');
        }
      }
    } else {
      $self->send($obj->name . "'s fields:");
      foreach (sort grep {$_ ne 'interp'} keys %$obj) {
        $self->send(sprintf "&fc;%12s&n;: %s", $_, $showsub->($obj->{$_}, $_));
      }
    }
    $self->connection->do_alias_cmd("# \@$target \$0");
  } else {
    $self->send("Sorry, I don't know what a $target is.\n");
  }
} else {
  $self->send("All possible field names:");
  my @fields = sort keys %MObject::Values;
  my $lines = int(@fields / 6) + 1;
  for (my $v = 0; $v < $lines; $v++) {
    my $buf = '';
    for (my $h = 0; $h < 6; $h++) {
      $buf .= sprintf "%-13s", $fields[$v + $h * $lines] || '';
    }
    $self->send($buf);
  }
}
