package MZonedHash::Rooms;
use MZonedHash;
@ISA = qw(MZonedHash);

use strict;
use Carp qw();
use MCoreTools;

sub _type_swap_in {
  my ($self, $zone) = @_;
  #warn Carp::longmess "DEBUG: _type_swap_in($zone)";
  my $zobj = MZone->by_path($zone) or do {
    mudlog "ERROR/WORLD: Access to nonexistent zone '$zone'";
    return;
  };
  return if $zobj->file_loaded('room');
  #mudlog "On-demand load: room:$zone";
  $zobj->load_file('room');
}

sub _type_store_zoned {
  my ($self, $zone, $key, $value) = @_;
  MZone->by_path($zone)->key_store('room', $key, $value);
}

sub _type_delete_zoned {
  my ($self, $zone, $key) = @_;
  MZone->by_path($zone)->key_delete('room', $key);
}


1;
