my $shelp = <<'EOHELP';
Says something to the people in the room with you.
EOHELP

MObject->Fields (
  can_speak => {default => 0},
);

MObject->Commands (
  say    => {code => sub {$_[0]->speak(text => $_[1], range => 4,   label => 'say', help => $shelp)}},
# shout  => {code => sub {$_[0]->speak(text => $_[1], range => 30,   label => 'shout')}},
# holler => {code => sub {$_[0]->speak(text => $_[1], range => 1000, label => 'holler')}},
  emote => {code => sub {
    my ($self, $args) = @_;
    $args or $self->send("Emote what?"), return;
    $args =~ s/([^!?.])$/$1./;
    my $npar = ($args =~ /\b(hit|you|stab|slash|pound|quit|leave|arrive|vanish)\b/);
    my $t = ($npar?"(":'') . $self->name . " $args" . ($npar?")":'');
    $self->act($t, $t);
  }, help => <<'EOH'},
This command allows you to describe actions that you perform. It has no effect on the world, and if your phrase contains a word which is considered to be an attempt to fool someone into thinking it's an actual game message, your message will be enclosed in parentheses.

Examples:
> emote smiles
Marn smiles.
> emote slashes you
(Marn slashes you.)
> emote looks around worriedly. You wonder why.
Marn looks around worriedly. You wonder why.
EOH
';' => {
  requires => [qw(nonplayer)],
  code => sub {
    my ($self, $args) = @_;
    foreach (values %MConnection::Connections) {
      my $po = $_->object;
      $po->send("&c;;" . $self->name . ": $args&n;") if ($po and $po->nonplayer);
    }
  },
},
    
);

MObject->CommandAliases (
  say => [qw(')],
  emote => [qw(:)],
);

MObject->ModMethods (

speak => sub {
  my ($self, %params) = @_;
  
  if (!$self->can_speak) {
    if ($self->has_metabolism) { # FIXME: has metab is not a good indicator of the presence of a mouth
      $self->send("You can't seem to get your mouth to form words.");
    } else {
      $self->send("You don't seem to have anything to speak with.");
    }
    return 0;
  }
  
  if ($self->drunk > 5) {local $_ = $params{text}; for my $i (1..$self->drunk - 5) {
    &{[
      sub {s/s/th/i},
      sub {s/le/la/i},
      sub {s/\B([a-df-ln-z])\1\B/$1$1-$1$1/i},
      sub {s/je/she/i},
      sub {s/go/guh/i},
      sub {s/ou/aw/i},
      sub {s/o/er/i},
      sub {s/u/ho/i},
      sub {s/e/ay/i},
      sub {s/e/ra/i},
      sub {s/\B[a-z]\B//i},
      sub {s/\s([\w])\B/ $1-$1-$1/i},
      sub {s/(\w{8})/"$1 *hic*"/ei},
      sub {s/ic/ic-hic/i},
    ]->[rand 14]};
  }; $params{text} = $_;}

  my $drt = $self->drunk > 5 ? ' drunkenly' : '';
  $self->nact("<self.aud?<self.name> $params{label}<self.is!s>$drt, '" . $self->dg_escape($params{text}) . "&n;'>");
  1;
},  

);
