MObject->ModFields (
  'immortal' => {default => 0},
  'CONTROLLER' => {default => 0, requires => [qw(CONTROLLER)]},
);

MObject->Commands (
'goto' => {
  requires => [qw(nonplayer)],
  code => sub {
    my ($self, $args) = @_;
    my $dest;
    my $silent = $args =~ s/\s*(-s)\s*//;
    if ($args =~ m#^/# and exists $::Rooms{$args}) {
      $dest = $::Rooms{$args};
    } else {
      my $obj = $self->object_find($args, entire_world => 1);
      $dest = $obj->container || $obj;
    }

    my $c = $dest;
    while ($c) {
      if ($c == $self) {
        $self->send('That would put you inside yourself.');
        return;
      }
      $c = $c->container;
    }

    if ($dest) {
      $self->act('Okay.', $self->name . ' disappears in a puff of smoke.') unless $silent;
      $self->move_into($dest);
      $self->act(undef, $self->name . ' appears with an ear-splitting bang.') unless $silent;
    }
  },
},
'transfer' => {
  requires => [qw(nonplayer)],
  code => sub {
    my ($self, $args) = @_;
    $args or do {
      $self->send("Transfer what??");
      return;
    };
    my $obj = $self->object_find($args, entire_world => 1);

    my $destination = $self->container;
    while ($destination->glance_contents) {
      $destination = $destination->container;
    }

    my $c = $destination;
    while ($c) {
      if ($c == $obj) {
        $self->send('That would put it inside itself.');
        return;
      }
      $c = $c->container;
    }

    if ($obj) {
      $obj->act($self->name . ' has transferred you!', $obj->name . ' disappears in a puff of smoke.');
      $obj->move_into($destination);
      $obj->act(undef, $obj->name . ' appears with an ear-splitting bang.');
    }
  },
},
'echo' => {
  requires => [qw(nonplayer)],
  code => sub {
    my ($self, $args) = @_;
    $self->act($args, $args);
  },
},
new => {
  requires => [qw(nonplayer)],
  code => sub {
    my ($self, $args) = @_;
    if (!$args) {
      $self->add_contents(MObject->new);
      $self->send("Empty object created.");
    } elsif (exists $MObject::Prototypes{$args}) {
      $self->add_contents(my $obj = new MObject('prototype' => $args));
      $self->act("You create @{[$obj->name]}.",
                 "@{[$self->name]} makes a peculiar gesture and @{[$obj->name]} appears in $GENDER_POSS{$self->gender} hand.");
    } else {
      $self->send('That prototype does not exist.');
    }
  },
  help => <<'EOHELP',
load &g;<prototype>&n;

Creates an object from the given prototype in your inventory.

Example:
 > load /lib/species/horse
 You create a horse.
EOHELP
},
'destroy' => {
  requires => [qw(nonplayer)],
  code => sub {
    my ($self, $args) = @_;
    if (!$args) {
      $self->send("Destroy what?");
      return;
    } elsif ('inventory' =~ /^$args/i) {
      foreach (@{$self->contents}) {
        $_->dispose;
      }
      $self->send('Inventory destroyed.');
    } else {
      my $had;
      foreach my $obj ($self->object_find($args)) {
        $had++;
        if ($obj->roomname) {
          $self->send("#@{[$obj->id]}: Use \@delete to destroy rooms.");
          next;
        }
        if ($obj->prototype and $obj->prototype ne '/core/ashes') {
          $obj->act(undef, $obj->name . " suddenly explodes in flames and burns to a crisp.");
          $obj->container->add_contents(MObject->new('prototype' => '/core/ashes'));
        }
        $obj->dispose;
      }
      if (!$had) {
        $self->send("I don't know what you're trying to destroy.");
      }
    }
  },
  help => <<'EOHELP',
destroy &g;<thing>&n;

Destroys the object(s) specified, leaving a pile of ashes.
EOHELP
},
list => {
  requires => [qw(nonplayer)],
  code => sub {
    my ($self, $zone) = @_;
    if ($zone) {
      $self->send("Items in $zone:");
      $self->do_multicol(
        "Prototypes:", map("&g;$_&n;", map {(my$t=$_)=~s/^$zone\///;$t} sort MZone->by_path($zone)->all_keys('obj')),
        "Rooms:", map("&b;$_&n;", sort MZone->by_path($zone)->all_keys('room')),
      );
    } else {
      $self->send("All zones:");
      $self->do_multicol(sort map $_->path, MZone->all_zones);
    }
  },
  help => <<'EOHELP',
list
list &g;<zone>&n;

Lists all zones, or the rooms and object prototypes in &g;<zone>&n;.
EOHELP
},
'shutdown' => {
  requires => [qw(immortal CONTROLLER)],
  code => sub {
    my ($self, $args) = @_;
    if (%::DirtyFiles and $args ne 'FORCE') {
      $self->send('There are unsaved files.');
      return;
    }

    mudlog "(PC) Shutdown by " . $self->name;
    MConnection->all_do(sub {
      my $self = $_[0]->object or return;
      #print "DEBUG: in shutdown, obj = $self\n";
      $self->act("You feel an odd inward pull, and the world vanishes around you.", $self->name . " seems to shimmer for a moment, then vanishes completely.");
      my $rn;
      { $self->loadroom(($self->container or last)->roomname or last); }
      $self->save_player();
      $self->saveable(0); # prevent dispose auto-save from wiping out objects
      $self->dispose;
    });
    MScheduler->stop();
  },
},
'eval' => {
  requires => [qw(immortal CONTROLLER)],
  code => sub {
    my ($self, $args) = @_;
    $self->send(eval $args, $@ || '');
  },
},
'dc' => {
  requires => [qw(immortal)],
  code => sub {
    my ($self, $args) = @_;
    my $con = MConnection->by_id($args) or do {
      $self->send("There is no connection with ID $args.");
      return;
    };
    mudlog "(PC) @{[$self->name]} disconnected connection $args (".$con->login_name.")";
    $con->disconnect;
  },
},
'dump' => {
  requires => [qw(nonplayer)],
  code => sub {
    my ($self, $args) = @_;
    $args or do {
      $self->send("Dump what??");
      return;
    };
    my $obj = $self->object_find($args, entire_world => 1) or do {
      $self->send("You do not see that here.");
      return;
    };
    
    use Data::Dumper;
    $self->send(Dumper($obj->clone_for_freeze));
  },
},
  force => {
    requires => [qw(nonplayer)],
    code => sub {
      my ($self, $args) = @_;
if ($args) {
  (my $view) = $args =~ s/-f\s+//i;
  my ($target, $str) = split /\s+/, $args, 2;
  if (my $obj = $self->object_find($target, entire_world => 1)) {
    if ($obj->immortal and !$self->CONTROLLER) {
      $self->send('Force someone your own size.');
      return;
    }
    $str ||= '';
    mudlog('(PC) ' . $self->name . ' forces ' . $obj->name . " to $str");
    
    if ($view) {
      $self->act("Okay; " . $obj->name . " sees:",
                 undef,
                 "@{[$self->name]} forces you to '$str'.",
                 $obj);
      local $obj->{connection} = $self->connection;
      local $self->{connection};
      $obj->do($str);
      $self->send('~~');
    } else {
      $self->act("Okay.",
                 undef,
                 "@{[$self->name]} forces you to '$str'.",
                 $obj);

      $obj->do($str);
    }
  } else {
    $self->send("You don't see a $target.\n");
  }
} else {
  $self->send('Force what??');
}
    },
  },
'users' => {
  requires => [qw(nonplayer)],
  code => sub {
    my ($self, $args) = @_;
    my $fmt = "%3s %-21s %-15s %-25s %-12s";
    $self->send(sprintf($fmt,
      qw(ID Source LoginName Object State),
    ));

    $self->send("--- --------------------- --------------- ------------------------- ------------");

    foreach (values %MConnection::Connections) {
      my $po = $_->object;

      $self->send(sprintf($fmt,
        $_->id, $_->source, $_->login_name || 'n/a', $po ? $po->name.'#'.$po->id : 'n/a', $_->{state},
      ));
    }
  },
},
'scheduler' => {
  requires => [qw(nonplayer)],
  code => sub {
    my ($self, $args) = @_;
    if ($args =~ /^stop ("|'|)(\d+)\1$/i) {
      if (!$self->CONTROLLER or MScheduler->task_owner($2) ne $self->id) {
        die "CFAIL:You do not have permission to remove that task.";
      }
      MScheduler->remove_task($2);
      $self->send("Task '$2' removed.");
    } else {
      $self->do_multicol(MScheduler->report);
    }
  },
  help => <<'EOHELP',
Displays the current status of the scheduler. The "Owner" column is the ID of the object that owns the task, if any.

If there are many tasks with negative "Runs-In" values, then the MUD is overloaded.
EOHELP
},
#'at' => {
#  requires => [qw(nonplayer)],
#  code => sub {
#    my ($self, $args) = @_;
#    my ($where, $cmd) = split /\s+/, $args, 2;
#    my $orig_cont = $self->container;
#    foreach my $at ($self->get_any_object($where)) {
#      if ($at->is_inside($self)) {
#        $self->send("You can't 'at' #@{[$at->id]} because it's inside you.);
#        return;
#      }
#      ($at->container ? $at->container : $at)->add_contents($self);
#      $self->do($cmd);
#    }
#    $orig_cont->add_contents($self);
#  },
#},
'grep' => {
  requires => [qw(nonplayer)],
  code => sub {
    use Data::Dumper ();
    my ($self, $args) = @_;
    my $pat = $args;
    my $found;
    MObject->all_do(sub {
      my ($obj) = @_;
      foreach (keys %$obj) {
        next unless $_ =~ /$pat/ or Data::Dumper::Dumper($obj->{$_}) =~ /$pat/;
        $self->send("Object #@{[$obj->id]} (@{[$obj->name]})");
        return;
      }
    });
    MObject->all_proto_do(sub {
      my ($name, $obj) = @_;
      foreach (keys %$obj) {
        next unless $name =~ /$pat/ or $_ =~ /$pat/ or Data::Dumper::Dumper($obj->{$_}) =~ /$pat/;
        $self->send("Prototype $name (@{[$obj->name]})");
        return;
      }
    });
  },
  help => <<'EOHELP',
The &c;grep&n; command searches all objects and object prototypes for the given regular expression. One should be careful with this command, as the wrong regexp can cause it to return every single object and prototype in the world; while this would not be
 a serious problem, it would likely tie up your terminal for a significant amount of time.
EOHELP
},
'sysinfo' => {
  requires => [qw(nonplayer)],
  code => sub {
    my ($self, $args) = @_;
    my ($buf, $t) = ('');

    $buf .= "mpMUD running on Perl $] on '$^O'.\n";
    $buf .= "This MUD is called '$::Texts{'name'}'.\n";
    $buf .= "$t is being used for storing structures.\n" if $t = $MFreezer::USE;
    $buf .= "$t scheduled tasks.\n" if $t = scalar @MScheduler::Tasks;
    $buf .= "$t objects in the world.\n" if $t = scalar keys %MObject::Objects;
    $buf .= "&c;$t unsaved files.&n\n" if $t = scalar keys %::DirtyFiles;
    $buf .= "$t\n" if $t = MScheduler->performance;
    $buf .= "Current time: $t\n" if $t = format_time(MScheduler->mudclock());
    
    $self->send($buf);
  },
  help => <<'EOHELP',
Displays various status information.
EOHELP
},
mkobs => {
  requires => [qw(immortal)],
  code => sub {
    my ($self, $args) = @_;

    my $obj = $self->object_find($args);
    my $con = MConnection::Capturing->new;
    $con->link_to_object($obj);
    $self->send(ucfirst $obj->name . " is now an observer.");
  },
},

review => { code => sub {
  my ($self, $args) = @_;

  $self->do_page($self->object_find($args)->connection->captured);
}},

);

MObject->CommandAliases(
  list => [qw(mlist olist rlist tlist)],
  destroy => [qw(purge)],
  new => [qw(load mload oload)],
);
