use MConnection::Capturing;

BEGIN {
  eval "use HTTP::Daemon; use HTTP::Status";
  if ($@) {
    mudlog "Could not load HTTP:: modules.";
    die "module load failed";
  }
}

my ($server, $capture, $tresp, $proxy, %coltab);

if ($MLoaders::ModuleEvalContext eq 'load') {
  $server = new HTTP::Daemon (
    LocalPort => 4001, # FIXME
    Timeout => .0001,
  );
  
  MScheduler->add_task(name => 'Web Server Poll', hook => sub {
    MScheduler->reset_me(5 * MScheduler::TIME_SCALE); # FIXME
    if (my $c = $server->accept) {
      $c->timeout(5);
      if (my $r = $c->get_request()) {CHAND:{
        $c->send_error(RC_FORBIDDEN), last CHAND 
          unless $r->method eq 'GET';
        my $path = $r->url->path;
        if ($path eq '/') {
          $tresp->($c, "<a href='who'>Who's connected right now</a>");
        } elsif ($path =~ m#^/edit/view/(.*)$#) {
          $tresp->($c, $capture->("\@view", $1, 1));
        } elsif ($path =~ m#^/help/(.*)$#) {
          $tresp->($c, $capture->("help", $1));
        } elsif ($path =~ m#^/who$#) {
          $tresp->($c, $capture->("who"));
        } else {
          $c->send_error(RC_NOT_FOUND);
        }
      }}
    }
  });
  
  $proxy = MObject->new(name => 'Web Server Proxy');
  
  %coltab = qw(k black r red g green y yellow b blue m magenta c cyan w white);
  
  $tresp = sub {
    my ($c, $text) = @_;
    $text =~ s/&n;?/<\/span>/g;
    $text =~ s/&f?([krgybmcw]);?/<span style="color:$coltab{$1}">/g;
    $text =~ s/&b([krgybmcw]);?/<span style="background-color:$coltab{$1}">/g;
    $c->send_response(new HTTP::Response
      RC_OK,
      "OK",
      HTTP::Headers->new(Content_Type => 'text/html'),
      "<html><head><title>mpMUD Web</title><body style=\"color: white; background-color: black\"><pre>$text</pre></body></html>",
    );
  };
  
  $capture = sub {
    my ($cmd, $args, $i) = @_;
    my $con = MConnection::Capturing->new;
    $proxy->connection($con);
    $proxy->immortal(1) if $i;
    $proxy->cmd_execute($cmd, $args);
    $proxy->immortal(0) if $i;
    $proxy->connection(undef);
    my $stuff = $con->captured;
  };
} elsif ($MLoaders::ModuleEvalContext eq 'unload') {
  $server->close if $server;
  MScheduler->remove_task('Web Server Poll');
  $proxy->dispose if $proxy;
}
