#!perl -w
use strict;

my @pronouns;

my @cases = qw(   subj      obj       poss      possp ); my @pronoun_table = map /^\s+(.*)$/, split /\n/,<<E;
  1     singular  I         me        my        mine
  1     plural    we        us        our       ours
  2     singular  ye        you       your      yours
  2     sing/infm thou      thee      thy       thine
  3     male      he        him       his       his
  3     female    she       her       her       hers
  3     singular  it        it        its       its
  3     plural    they      them      their     theirs
  0     singular  who       whom      whose     whose
  0     plural    who       whom      whose     whose
E

foreach (@pronoun_table) {
  my @item = split / +/;
  $pronouns[$item[0]]{$item[1]} = {map +($cases[$_], $item[$_+2]), 0..3};
}
foreach (@pronouns) {
  $_->{male} ||= $_->{singular};
  $_->{female} ||= $_->{singular};
}

use Data::Dumper;
print Dumper \@pronouns;