Define Fields => {
  container   => {noset => 1, noinherit => 1, nofreeze => 1},
  contents    => {noset => 1, noinherit => 1, nofreeze => 1, default => []},

  weight => {default => 10},
  density => {default => 1},
  
  i_weight => {default => 0, noset => 1, noinherit => 1, nofreeze => 1},
  i_volume => {default => 0, noset => 1, noinherit => 1, nofreeze => 1},
  i_change_notify_val =>    {noset => 1, noinherit => 1},
  
  cnt_closeable => {default => 0},
  cnt_closed => {default => 0},

}, Methods => {

add_contents => sub {
  my ($self, @objs) = @_;
  $self->locked and croak("add_contents called on locked object");
  
  my $contents = $self->getAttr('contents');
  
  my $tweight = my $tvol = 0;
  foreach my $obj (@objs) {
    $obj->locked and croak("add_contents called with locked object");
    { ($obj->container or last)->remove_contents($obj); }
    $obj->container($self);
    push @$contents, $obj;
    $tweight += $obj->total_weight;
    $tvol += $obj->total_volume;
  }
  $self->setAttr('contents', $contents);
  $self->send_i_change($tweight, $tvol);
  1;
},

remove_contents => sub {
  my ($self, @remove) = @_;

  my %remove = map {$_->id, 1} @remove;
  my $clist = $self->getAttr('contents');
  my $tweight = my $tvol = 0;
  
  for (my $i = 0; $i < @$clist; $i++) {
    next unless $remove{(my $obj = $clist->[$i])->id};
    $tweight += $obj->total_weight;
    $tvol += $obj->total_volume;
    $obj->resetAttr('container');
    splice @$clist, $i--, 1;
    # $i decremented since the indices change due to splicing the array
  }
  $self->setAttr('contents', $clist);
  if (@$clist) {
    $self->send_i_change(-$tweight, -$tvol);
  } else {
    $self->send_i_change(-$self->i_weight, -$self->i_volume);
  }
  1;
},

send_i_change => sub {
  my ($self, $tweight, $tvol) = @_;
  
  my $info = {weight => $tweight, volume => $tvol};
  call_hooks('i_change_propagation', $self, $info);

  if (my $iv = $self->i_change_notify_val) {
    $info->{weight} += $iv->[0];
    $info->{volume} += $iv->[1];
    MScheduler->remove_event($iv->[2]);
  }
    
  (my $evt = MEvent::Message->new(
    name => "Weight Change Notification",
    'time' => 0,
    owner => $self,
    target => 'MCoreTools',
    method => 'call_hooks',
    arguments => ['i_change', $self, $info],
  ))->schedule;
  $self->i_change_notify_val([$info->{weight}, $info->{volume}, $evt]);
},

move_into => sub {
  my ($self, $dest, %info) = @_;

  defined $dest or do {$self->container->remove_contents($self); return};
  $dest->is_inside_or_same($self) and croak "can't move #".$self->id." into #".$dest->id.": would cause containment loop";

  my $self_container = $self->container || 0;
  my $dest_container = $dest->container || 0;

  my $temp;
  my $old_view = $self_container; if ($old_view) { $old_view = $temp while $old_view->glance_contents and $temp = $old_view->container; }
  my $new_view = $dest || 0;      if ($new_view) { $new_view = $temp while $new_view->glance_contents and $temp = $new_view->container; }
  my $dolook = $old_view != $new_view;

  #my @old_loc = $self->location_in(undef);

  $dest->add_contents($self);
  
  if ($dolook) {
    call_hooks('cnt_changed', $self);
    if ($self->glance_contents) {
      foreach (@{$self->contents}) {
        call_hooks('cnt_changed', $_);
      }
    }
  }
  
  $self->sact(
    [acti=>{
        type => 'motion',
        subtype => $info{action},
      },
      ($info{actor} ? [obj=>{role => 'actor', oid => $info{actor}->id}] : ()),
      [obj=>{role => 'self', oid => $self->id}],
      [obj=>{role => 'to', oid => $dest->id}],
      ($self_container ? [obj=>{role => 'from', oid => $self_container->id}] : ()),
    ],
    ($self_container?$self_container:())
  );
  
#   if (0) {
#     my @delta = $self->location_in(undef);
#     local $" = ', ';
#     for (my $i = 0; $i < @delta; $i++) {
#       $delta[$i] -= $old_loc[$i];
#     }
# 
#     #$self->send("[ Delta: @delta ]");
#   }
  1;
},

is_inside => sub {
  my ($inner, $outer) = @_;
  $inner = $inner->container; # prevent $self->is_inside($self) == 1
  while ($inner) {
    return 1 if $inner->id == $outer->id;
    $inner = $inner->container;
  }
  return 0;
},

is_inside_or_same => sub {
  my ($inner, $outer) = @_;
  while ($inner) {
    return 1 if $inner->id == $outer->id;
    $inner = $inner->container;
  }
  return 0;
},

can_contain => sub {
  my ($self, $other) = @_;
  return $self->cnt_type eq 'open' || ($other->total_volume + $self->i_volume <= $self->cnt_interior);
},

volume => sub {$_[0]->weight / $_[0]->density},
total_weight => sub {$_[0]->weight + $_[0]->i_weight},
total_volume => sub {$_[0]->volume + ($_[0]->cnt_type eq 'hard' ? 0 : $_[0]->i_volume)},

# location_in => sub {
#   my ($self, $in) = @_;
# 
#   my @loc = @{$self->location};
#   my $container = $self;
#   while ($container = $container->container and not ($in and $in->id == $container->id)) {
#     my @cloc = @{$container->location};
#     @loc == @cloc or mudlog "ERROR/CORE: Coordinate mismatch: #".$self->id." has ".@loc." coordinates, #".$container->id." has ".@cloc;
#     for (my $i = 0; $i < @loc; $i++) {
#       $loc[$i] += $cloc[$i];
#     }
#   }
#   !$in or ($container and $in->id == $container->id) or croak "location_in: #".$self->id." not inside #".$in->id;
#   return @loc;
# },
};


Define Hooks => {
'cnt_changed' => sub {
  my ($self) = @_;
  $self->send([division=>{}]);
  #FIXME: need some way to execute 'look' and send output to all connections...maybe look should be a method etc.
  #cmd_execute(undef, $self, 'look', '');
  my $trans = MTransaction->open(); # FIXME: this is only for context, remove this when context gets separate mechanism
  $self->send(MDefList->path('/Commands/look')->{code}->($self, ''));
  $trans->commit;
  $trans->close;
},
'i_change_propagation' => sub {
  my ($self, $info) = @_;
  
  { ($self->container or last)->send_i_change($info->{weight}, $info->{volume}); }
  $self->i_weight($self->i_weight + $info->{weight});
  $self->i_volume($self->i_volume + $info->{volume});
},
'i_change' => sub {
  $_[0]->resetAttr('i_change_notify_val');
},
'object_destruction' => sub {
  my ($self) = @_;
  if (my $con = $self->contents) {
    foreach (@$con) {
      next unless ref $_ and $_->ref_exists;
      $_->setAttr('container', undef);
    }
    if ($self->container) {
      $self->container->add_contents(@$con);
    }
    $self->resetAttr('contents');
  }
  if (my $sc = $self->container) {
    $sc->remove_contents($self); 
  }
},
};
