Require 'commands';

Define Fields => {
  exits => {default => {},},
  rideable => {default => 0,},
};

my %dir_opp = qw(
  north south
  west east
  up down
  northwest southeast
  southwest northeast
);
@dir_opp{values %dir_opp} = keys %dir_opp;
my %dir_name = qw(
  n north
  e east
  s south
  w west
  ne northeast
  se southeast
  sw southwest
  nw northwest
  u up
  above up
  d down
  below down
);
@dir_name{keys %dir_opp} = keys %dir_opp;
#mudlog Data::Dumper::Dumper(\%dir_name);
my $name_match = '(' . join('|', keys %dir_name) . ')';
my %exit_sort = qw(
  north 1
  northeast 2
  east 3
  southeast 4
  south 5
  southwest 6
  west 7
  northwest 8
  up 9
  down 10
);
my %terrain_move = qw(
  indoors .8
  city 1
  field 1.2
  forest 1.6
  hills 2.5
  mountain 5
  water_swim 10
  water_noswim 10
  underwater 2
  flying .5
);

Define Actions => {
  'motion-exit' => '',
};

Define Subs => {

opposite_dir => sub {
  return $dir_opp{$_[0]};
},

dir_desc => sub {
  my ($dir, $type) = @_;
  if ($dir eq 'up') {
    return "up" if $type eq 'to';
    return "$type above";
  } elsif ($dir eq 'down') {
    return "down" if $type eq 'to';
    return "$type below";
  } else {
    return "$type the $dir";
  }
  
},

};

Define Methods => {

match_exit => sub { ################
  my ($self, $name) = @_;

  $name =~ s/\s*\b$name_match\b\s*//;
  my $dir = $1 ? $dir_name{$1} : '';

  #mudlog "DEBUG: m_e dir=$dir name=$name";
  if (!$name and !$dir) {
    die "CFAIL:What direction?";
  }

  my $cexits = $self->container->exits;
  return ($cexits->{$dir}, $dir) if $dir;

  foreach my $ename (keys %$cexits) {
    my $exit = $cexits->{$ename};
    if ($exit->{door} and $exit->{door} =~ /\b\Q$name\E\b/) {
      return ($exit, $ename);
    }
  }
  die "CFAIL:You don't see any '$name' here.";
},

move_direction_cmd => sub { ################
  my ($self, $dir) = @_;

  if (!$dir) {
    $self->send("Go in what direction?");
    return;
  }
  my $inside = $self->container;
  $inside or do {
    $self->send("Move? How?");
    return 0;
  };
  $dir = $self->match_exit($dir);

  if ($inside->rideable) {
    if (MModules->loaded('body_pos') and !$inside->bp_can('move')) {
      return [error=>{}, desc_gen('{i} is not in a suitable position for moving.', self => $self, i => $inside)];
    }
    $self->send([action=>{}, desc_gen("<self> <v:command> <self.ppron> <i.name> to move $dir.", self => $self, i => $inside)]);
    $inside->move_direction_cmd($dir);
    return;
  }
   return $self->move_direction($dir);
},
move_direction => sub { ################
  my ($self, $dir) = @_;

  my $inside = $self->container;  
  
  while ($inside->glance_contents) {
    last if $inside->cnt_closed;
    $inside = $inside->container;
  }
    
  $inside or die "CFAIL:Move? How?";
  my $exit = $inside->exits->{$dir};
  $exit and $exit->{to} or die "CFAIL:Alas, you cannot go $dir...";

  $exit->{to}->ref_exists or do {
    mudlog("ERROR/WORLD: nonexistent object #".$exit->{to}->id." referred to in $dir exit at room #s@{[$self->container->id]}");
    $self->send('You try to go there, but a peculiar force prevents you.');
    return;
  };
  my $pts = .1 ;# * $terrain_move{$inside->terrain || 'city'}; #FIXME

  MModules->loaded('body_pos') and $self->bp_assert('move', 'move around');

  if ($exit->{closed}) {
    $self->nact("<self> tries to go $dir but <v:bumps> <self.ppron> nose on $exit->{door}.");
    return;
  }
  #if ($self->m_move) {
  #  if ($pts > $self->c_move) {
  #    return [error=>{}, desc_gen('{mov} {self?are:is} too tired.', mov => $self, self => $self)];
  #  }
  #  $self->c_move($self->c_move - $pts);
  #}
  return if grep !$_, call_hooks('exits_movement_ok', $self, $dir);

  $self->nact("<self.vis?<self> <v:leaves> $dir.>");
  $self->move_into($exit->{to}, actor => $self, action => 'exit');
  $self->nact("<self.vis?<self!<self> has arrived @{[dir_desc(opposite_dir($dir), 'from')]}.>>");
  #FIXME $self->pause_commands($pts * 60);
  return;
},

}, Commands => {
north     => {aliases => [qw(n)], code => sub {$_[0]->move_direction_cmd('north')}},
east      => {aliases => [qw(e)], code => sub {$_[0]->move_direction_cmd('east')}},
south     => {aliases => [qw(s)], code => sub {$_[0]->move_direction_cmd('south')}},
west      => {aliases => [qw(w)], code => sub {$_[0]->move_direction_cmd('west')}},
up        => {aliases => [qw(u)], code => sub {$_[0]->move_direction_cmd('up')}},
down      => {aliases => [qw(d)], code => sub {$_[0]->move_direction_cmd('down')}},
northeast => {aliases => [qw(ne)], code => sub {$_[0]->move_direction_cmd('northeast')}},
southeast => {aliases => [qw(se)], code => sub {$_[0]->move_direction_cmd('southeast')}},
southwest => {aliases => [qw(sw)], code => sub {$_[0]->move_direction_cmd('southwest')}},
northwest => {aliases => [qw(nw)], code => sub {$_[0]->move_direction_cmd('northwest')}},
go        => {aliases => [qw(move run walk)], code => sub {$_[0]->move_direction_cmd($_[1])}},

'rnew' => {
  requires => [qw(builder)],
  code => sub {
    my ($self, $args, %info) = @_;

    $args or die "CFAIL:Usage: rnew [-t] <name for room>";
    my $room = MObject->new('prototype' => 'room', owner => eval {$info{connection}->user->name} );
    $room->addName($args);
    $self->do('goto #' . $room->id) if $info{opt_t} || $info{opt_tele};
  },
},  

'@exit' => {
  requires => [qw(builder)],
  code => sub {
    my ($self, $args) = @_;
    my $rev = not ($args =~ s/\s*(-r)\s*//);

    #print "entering \@exit\n";
    my ($dir, $command, $param) = split /\s+/, $args, 3;

    unless ($dir) {
      $self->send("Edit an exit, sure, but what exit?");
      return;
    }

    my $odir;
    !$rev or $odir = opposite_dir($dir) or die "CFAIL:I don't know the opposite of $dir.";

    #print "this room\n";
    my $this_room = &edit_target_obj;
    my $this_exits = $this_room->getAttr('exits');
    my $this_exit = $this_exits->{$dir};
    
    #print "other room\n";
    my ($other_room, $other_exits, $other_exit);
    if ($this_exit and $other_room = $this_exit->{to} and $other_room->ref_exists) {
      #print "getting exits\n";
      $other_exits = $other_room->getAttr('exits');
      #print "getting exit\n";
      $other_exit = $other_exits->{$odir} if $odir;
    }

    #print "after vars config\n";
    #$self->send("debug: other_room id = ".$other_room->id);
    #$self->send("rev mode is $rev");

    edit_priv_assert($other_room) if $other_room; # check privileges

    $command or die "CFAIL:But what do you want to do there? (Usage: \@exit dir command [param])";

    if ($command ne 'to' and not $this_exit) {
      $self->send("But there's no exit $dir to edit! (Maybe you should make one.)");
      return;
    }

    if ($command eq 'delete' or $command eq 'purge') {
      delete $this_exits->{$dir};
      delete $other_exits->{$odir} if $rev;
      $self->send("\u$dir exit deleted.");
      
    } elsif ($command eq 'to' or $command =~ /[#$]/) {
      $param = $command if $command ne 'to';
      $other_room = $self->object_find($param);
      $other_exits = $other_room->getAttr('exits') if $rev;
      if (!$this_exit) {
        $this_exits-> {$dir}  = {to => $other_room};
        $other_exits->{$odir} = {to => $this_room} if $rev;
        $self->send("$dir exit created to $param.");
      } else {
        #print "in redirect\n";
        $other_exit = $other_exits->{$odir} if $odir;
        $this_exit->{to} = ObjectByID($param);
        $other_exit->{to} = $this_room if $rev and $other_exit;
        $self->send("$dir exit redirected to $param.");
        $self->send("You might want to change the exit description.") if $this_exit->{desc};
        #print "after redirect\n";
      }

    } elsif ($command eq 'desc') {
      $this_exit->{desc} = $param;
      $other_exit->{desc} = $param if $rev;
      $self->send("Description set.");

    } elsif ($command eq 'door') {
      $this_exit->{door} = $param;
      $other_exit->{door} = $param if $rev;
      $self->send("Door '$param' created.");

    } elsif ($command eq 'key') {
      $this_exit->{door} or die "CFAIL:But there's no door!";
      $this_exit->{key} = $param;
      $other_exit->{key} = $param if $rev;
      $self->send("Key set.");

    } elsif ($command eq 'pick') {
      $this_exit->{door} or die "CFAIL:But there's no door!";
      $this_exit->{pick_difficulty} = $param;
      $other_exit->{pick_difficulty} = $param if $rev;
      $self->send("Pick difficulty set.");

    } elsif ($command eq 'open') {
      delete $this_exit->{door};
      delete $this_exit->{closed};
      delete $this_exit->{locked};
      delete $this_exit->{pickproof};
      delete $this_exit->{key};
      if ($rev) {
        delete $other_exit->{door};
        delete $other_exit->{closed};
        delete $other_exit->{locked};
        delete $other_exit->{pickproof};
        delete $other_exit->{key};
      }
      $self->send("Door removed.");
    } else {
      $self->send("Sorry, but I don't know what '$command' means.");
      return;
    }
    $this_room ->setAttr('exits', $this_exits ) if $this_room  and $this_exits;
    $other_room->setAttr('exits', $other_exits) if $other_room and $other_exits;
  },
  help => <<'EOHELP',
@exit [-r] &:meta<direction>&:n &:meta<command>&:n &:meta<param>&:n

The &:y;@exit&:n command is used for creating, deleting, and modifying room exits.

The -r switch tells it not to do matching operations on the opposing exit (the exit in the opposite direction in the room this exit leads to).

&:title;Creating Exits&:n

@exit east /test/center
@exit east to /test/center

will create an exit east from the currently selected object, connecting to the room /test/center, and an exit west from the room /test/center, connecting to the currently selected object (if it is a room).

&:title;Deleting Exits&:n

@exit north delete
@exit north purge

will remove the exit in the specified direction, and the opposing exit.

&:title;Description&:n

@exit east desc <description>
will add a description to the exit.

&:title;Doors&:n

@exit east door <name>
will create a door for the given exit. <name> should be the name of the door.

@exit east open
will remove the door (and key information) on the exit.

@exit east key <proto>
sets the object required to unlock the door.

@exit east pick <difficulty>
sets the difficulty of picking the lock on the door. 0 is 'very easy' and 1 is completely impossible.
EOHELP
},
};

Define Hooks => {
  look_extra_info => sub {
    my ($self, $viewer, %info) = @_;
    return unless $viewer->can_see($self) and $info{outward};

    my $estr = join(' ', map { my $e = $self->exits->{$_};
                               !$e->{to} ? () : $e->{closed} ? ($e->{minor} ? () : "($_)") : $_;
                             }
                             sort {($exit_sort{$a} || 0) <=> ($exit_sort{$b} || 0)}
                             keys %{$self->exits});
    return $estr ? ['html:em',{}, "Exits: $estr"] : ();
  },
};

=cut

1;