Require 'privcore', 'commands';

Define Commands => {
#---------------------------------------------------------------------------------------------------
'goto' => {
  requires => [qw(watcher)],
  code => sub {
    my ($self, $args, %info) = @_;
    my $dest;
    my $silent = $info{opt_s} || $info{opt_silent};
    
    my $obj = $self->object_find($args, entire_world => 1);
    $dest = $obj->container || $obj;

    my $c = $dest;
    while ($c) {
      if ($c == $self) {
        $self->send('That would put you inside yourself.');
        return;
      }
      $c = $c->container;
    }

    $self->nact('<self?The world:<self>> disappears in <self?whiteness:a puff of smoke>.') unless $silent;
    $self->move_into($dest);
    $self->nact('<self> appear<self!s> with a <self!n ear-splitting >bang.') unless $silent;
  },
  help => <<'EOHELP',
goto [-s] &:meta;<object>&:n;

Moves you into the container of the object, or into the object if it has no container. The -s option prevents any messages from being seen by others.
EOHELP
},
#---------------------------------------------------------------------------------------------------
'transfer' => {
  requires => [qw(runner)],
  code => sub {
    my ($self, $args) = @_;
    $args or do {
      $self->send("Transfer what??");
      return;
    };
    my $obj = $self->object_find($args, entire_world => 1);

    my $destination = $self->container or die "CFAIL:You need to be inside something to transfer an object.";
    while ($destination->glance_contents) {
      $destination = $destination->container;
    }

    my $c = $destination;
    while ($c) {
      if ($c == $obj) {
        $self->send('That would put it inside itself.');
        return;
      }
      $c = $c->container;
    }

    $obj->nact('<self?The world:<self>> disappears in <self?whiteness:a puff of smoke>.');
    $obj->move_into($destination);
    $obj->nact('<self!<self> appears with an ear-splitting bang.>');
  },
  help => <<'EOHELP',
transfer &:meta;<object>&:n;

Moves an object into the same container as yourself.
EOHELP
},
#---------------------------------------------------------------------------------------------------
create => {
  aliases => [qw(new load oload)],
  requires => [qw(builder)],
  optional_object => 1,
  code => sub {
    my ($self, $args, %info) = @_;
    
    my %attrs = (owner => $info{connection}->user->name);
    
    my ($proto, $named) = split /\s+/, $args, 2;
    
    if (defined $proto and length $proto and $proto ne 'object') {
      $proto =~ s/^\$//;
      ObjectByName($proto) or die "CFAIL:There is no prototype named '$proto'.";
      $attrs{prototype} = $proto;
    }
    
    if (defined $named and length $named) {
      $named =~ s/^(?:(?:named|called|as)\s+)+//;
      $named =~ s/^(an?|the)\s+// and $attrs{article} = $1;
      $attrs{name} = $named;
    }
    
    my $obj = MObject->new(%attrs);
    $self->nact('<self> <v:makes> <self?the appropriate:a peculiar> gesture and <obj> appears in <self.ppron> hand.', obj => $obj)
      unless !$self or $info{opt_s} or $info{opt_silent};
    eval {$obj->move_into($self)};
      
    $info{connection}->cmd_execute($self, '@select', '#' . $obj->id)
      unless $info{opt_n} or $info{opt_noselect};
    return;
  },
  help => <<'EOHELP',
create [-s[ilent]] [-n[oselect]] <prototype> [named <name>]
Creates an object in your inventory and selects it for editing.
EOHELP
},
#---------------------------------------------------------------------------------------------------
'clone' => {
  requires => [qw(builder)],
  code => sub {
    my ($self, $args) = @_;
    my $obj = $self->object_find($args, entire_world => 1);
    $obj->container->add_contents(MObject->thaw($obj->freeze));
  },
  help => <<'EOHELP',
clone &g;<thing>&n;

Duplicates the object(s) specified.
EOHELP
},
#---------------------------------------------------------------------------------------------------
'destroy' => {
  aliases => [qw(purge)],
  requires => [qw(builder)],
  code => sub {
    my ($self, $args) = @_;
    foreach my $obj ($self->object_find($args, entire_world => 1, verb => 'destroy')) {
      my $name = $obj->getAttr('name');
      $args =~ /\Q$name/ or $self->send([error=>{}, $obj, ': you must completely specify the name of an object to be destroyed.']), next;
      edit_priv_assert($obj);
      if ($obj->getAttr('decay_time')) {
        $obj->decay;
      } else {
        $obj->nact('<self> suddenly <v:explodes> in flames and <v:burns> to a crisp.');
        $obj->container->add_contents(MObject->new('prototype' => 'Pashes'))
          if $obj->container and ObjectByName('Pashes');
        $obj->destroy;
      }
    }
  },
  help => <<'EOHELP',
destroy &g;<thing>&n;

Destroys the object(s) specified, either by natural decay or spontaneous combustion.
EOHELP
},
#---------------------------------------------------------------------------------------------------
'shutdown' => {
  requires => [qw(controller)],
  no_object => 1,
  code => sub {
    my ($con, $args) = @_;

    mudlog "(PC) Shutdown by " . $con->user->name;
    $::Quit = 'normal';
    return;
  },
  help => <<'EOHELP',
Shuts down mpMUD.
EOHELP
},
#---------------------------------------------------------------------------------------------------
'reboot' => {
  requires => [qw(controller)],
  no_object => 1,
  code => sub {
    my ($con, $args, %info) = @_;

    mudlog "(PC) Reboot by " . $con->user->name;
    $::Quit = 'restart';
    return;
  },
  help => <<'EOHELP',
Shuts down mpMUD and attempts to restart it.
EOHELP
},
#---------------------------------------------------------------------------------------------------
'eval' => {
  aliases => [qw(`)],
  no_parse_args => 1,
  optional_object => 1,
  requires => [qw(controller)],
  code => sub {
    my ($self, $args, %info) = @_;
    my $con = $info{connection};

    my (@warnings, @result);
    {
      local $SIG{__WARN__} = sub {push @warnings, @_};
      @result = eval qq{\n#line 1 "(eval for user } . (eval {$con->user->name} || 'unknown') . qq{)"\n\{;} . $args . "\n;}";
    }
    return [error=>{}, ['html:pre'=>{}, @warnings, $@ ]] if $@;
    
    my $disp;
    if ($info{opt_l} || $info{opt_list}) {
      $disp = ['html:ul'=>{'html:class'=>'structure'}, map ['html:li'=>{}, "$_"], @result];
    } elsif ($info{opt_s} || $info{opt_sx}) {
      $disp = [group=>{}, @result];
    } else {
      $disp = ['html:ul'=>{'html:class'=>'structure'}, map ['html:li'=>{}, sx_dump_thingy($_, get => 1)], @result];
    }
    [report=>{}, [title=>{}, qq{"$args"}], (@warnings ? ['html:pre'=>{}, @warnings] : ()), $disp];
  },
  help => [group=>{}, ['html:p'=>{}, 'Evaluates its argument as Perl code.'], ['html:p'=>{}, 'The -l[ist] and -s[x] options affect how the '.
  'return value is displayed. The default is to dump it as an pseudo-expression. -l[ist] causes them to be '.
  'displayed as strings in a list. -s[x] results in no interpretation; this is useful for testing '.
  'SX generation.']],
},
#---------------------------------------------------------------------------------------------------
'call' => {
  aliases => [qw(~)],
  no_parse_args => 1,
  requires => [qw(controller)],
  code => sub {
    my ($self, $args, %info) = @_;
    
    $args =~ s/^\((.*?)\)\s+// or $args =~ s/^(\S+)\s+// or die "CFAIL:No object specified!";
    my $obj = $self->object_find($1);
    my $code = "ObjectByID(" . $obj->id . ")->$args";
    $info{connection}->cmd_execute($self, 'eval', $code, %info);
    return;
  },
  help => <<'EOHELP',
call &:g;<target> <meth>&:n;

Looks for the object named <target> and executes the Perl code "$obj->&:g;<meth>&:n;".

Example:
  > call chair nphr(2)
  2 chairs
EOHELP
},
#---------------------------------------------------------------------------------------------------
'dcother' => {
  requires => [qw(runner)],
  no_object => 1,
  code => sub {
    my ($self, $args, %info) = @_;
    my $con = MConnection->by_id($args) or die "CFAIL:There is no connection with ID $args.";
    $con->disconnect('by '.$self->user->name.' (PC)');
  },
  help => <<'EOHELP',
Disconnects the connection with the specified ID.
EOHELP
},
#---------------------------------------------------------------------------------------------------
# # this is disabled pending consideration in new command interpreter model
# force => {
#   requires => [qw(runner)],
#   code => sub {
#     my ($self, $args, %info) = @_;
#     
#     (my $view) = $args =~ s/-f\s+//i;
#     
#     my ($target, $str) = split /\s+/, $args, 2;
#     
#     my $obj = $self->object_find($target, entire_world => 1, verb => 'force');
#     
#     if ($obj->priv_watcher and !$self->priv_controller) {
#       die 'CFAIL:Force someone your own size.';
#     }
#     $str or return [error=>{}, "Force ",$obj," to what?"];
#     
#     $obj->dg_send("<from> forces you to '$str'.", from => $self);
#     mudlog '(PC) ' . $info{connection}->user->name . ' forces ' . $obj-> nphr . " to $str";
# 
#     $obj->do($str);
#   },
#   help => <<'EOHELP',
# force [-f] &:meta;<object>&:n; &:meta;<command>&:n;
# 
# Causes the specified object to execute the command. The -f option allows you to see the text sent to the object during the execution of the command.
# EOHELP
# },
#---------------------------------------------------------------------------------------------------
# # this table display was such an interesting piece of code, too bad it's not useful now, *snif*
#connections => {
#  requires => [qw(watcher)],
#  code => sub {
#    my ($self, $args) = @_;
#    my @names = qw(ID Source User Object State Idle);
#    my @data;
#    my @max = map length, @names;
#
#    foreach (sort {$b->id <=> $a->id} MConnection->all) {
#      my $po = $_->object;
#      my @s;
#
#      $s[0] = $_->id;
#      $s[1] = $_->source;
#      $s[2] = $_->user ? $_->user->name : '';
#      $s[3] = $po ? $po-> nphr.'#'.$po->id : '';
#      $s[4] = $_->state;
#      $s[5] = format_time($_->idle_time);
#  
#      for (my $i = 0; $i < @s; $i++) {
#         $max[$i] = length $s[$i] if length $s[$i] > $max[$i];
#      }
#
#      push @data, \@s;
#    }
#    
#    my $fmt = (join ' ', map {"%-${_}s"} @max);
#    my @buf = sprintf($fmt, @names);
#    push @buf, join ' ', map {'-' x $_} @max;
#    foreach (@data) {
#      push @buf, sprintf($fmt, @$_);
#    }
#
#    [report=>{}, ['html:pre',{}, join "\cJ", @buf]];
#  },
#},
#---------------------------------------------------------------------------------------------------
connections => {
  no_object => 1,
  aliases => [qw(users)],
  requires => [qw(watcher)],
  code => sub {
    [report=>{}, ['html:table', {}, 
      ['html:tr', {}, map ['html:th', {}, $_], qw(ID Source User Object State Idle)],
      map ['html:tr', {}, map ['html:td', {}, $_], (
        $_->id,
        $_->source,
        $_->user ? $_->user->name : '',
        $_->object ? [obj=>{oid=>$_->object->id,part=>'idn'}] : '',
        $_->state,
        format_time($_->idle_time),
      )], sort {$b->id <=> $a->id} MConnection->all
    ]];
  },
},
#---------------------------------------------------------------------------------------------------
scheduler => {
  no_object => 1,
  aliases => [qw(ps events)],
  requires => [qw(watcher)],
  code => sub {
    [report=>{}, ['html:table'=>{}, 
      ['html:tr'=>{}, map ['html:th'=>{}, $_], qw(Name Runs-in Owner)],
      ['html:tr'=>{}, (['html:th'=>{}, [division=>{}]]) x 3],
      map ['html:tr'=>{}, map ['html:td'=>{}, $_], (
        $_->{dead} ? '<dead>' : $_->{name},
        format_time($_->{runs_in}),
        ($_->{owner} ? $_->{owner} : 'n/a'),
      )], grep !$_->{dead}, MScheduler->report
    ]];
  },
},
#---------------------------------------------------------------------------------------------------
info => {
  requires => [qw(runner)],
  code => sub {
    [report=>{}, [title=>{}, 'mpMUD Info'], ['html:ul'=>{}, 
      ['html:li'=>{}, "Perl version and OS: ",     "$] on '$^O'"],
      ['html:li'=>{}, "MUD name: ",                $::Config{'name'}],
      ['html:li'=>{}, "Freezer: ",                 $MFreezer::USE],
      ['html:li'=>{}, "Events in queue: ",         scalar @MScheduler::Events],
      ['html:li'=>{}, "Objects cached: ",          scalar keys %MObjectDB::ObjCache],
      ['html:li'=>{}, "Decached objects leaked: ", scalar keys %MObject::StaleObjects],
      ['html:li'=>{}, "Nil connections leaked: ",  $MConnection::Nil::Stale],
      ['html:li'=>{}, "Current real time: ",       format_time(MScheduler::realclock()), ' ', scalar MScheduler->clock_localtime(MScheduler->realclock())],
    ]];
  },
},
#---------------------------------------------------------------------------------------------------
mkobs => {
  requires => [qw(watcher)],
  code => sub {
    my ($self, $args) = @_;

    use MConnection::Capturing;
    my $obj = $self->object_find($args);
    my $con = MConnection::Capturing->new;
    $con->attach($obj);
    $obj->nact("<self> <self?are:is> now an observer.");
  },
  help => <<'EOHELP',
Creates a 'capturing' connection and attaches it to the object specified, so that it logs all text sent to it.

This can not currently be used on players.
EOHELP
},
#---------------------------------------------------------------------------------------------------
# 'spew' => {
#   requires => [qw(controller)],
#   code => sub {
#     my ($self, $args) = @_;
# 
#     my $buf = '';
#     for (my $i = 1; $i <= $args; $i++) {
#       $buf .= join '', "$i: ", ((0..9) x 7), "\n";
#     }
#     return $buf;
#   },
#   help => <<'EOHELP',
# Dumps <arg> lines of text to your terminal.
# EOHELP
# },
#---------------------------------------------------------------------------------------------------
'privilege' => {
  requires => [qw()],
  no_object => 1,
  code => sub {
    my ($self, $args, %info) = @_;
    my @p = keys %{$self->user->get('privileges')}
      or return [report=>{}, [line=>{}, 'You have no privileges.']];
    [report=>{}, 
      [title=>{}, 'Your privileges'],
      ['html:ul'=>{}, map ['html:li'=>{}, $_], @p],
    ];
  },
  help => 'Lists your privileges.',
},
#---------------------------------------------------------------------------------------------------
'privset' => {
  requires => [qw(controller)],
  no_object => 1,
  code => sub {
    my ($self, $args, %info) = @_;

    my @args = split /\s+/, $args;
    @args == 1 or @args == 3
      or return [error=>{}, 'Usage: privset <user>[ <priv> (set|clear)]'];

    my $ouser = MUser->get($args[0]) or die "CFAIL:No such user '$args[0]'.";
    my %priv = %{$ouser->get('privileges') || {}};
    if (@args == 1) {
      [report=>{}, 
        [title=>{}, $ouser->name, "'s privileges"],
        ['html:ul'=>{}, map ['html:li'=>{}, $_], keys %priv],
      ];
    } else {
      if ($args[2] eq 'set') {
        $priv{$args[1]} = 1;
      } elsif ($args[2] eq 'clear') {
        delete $priv{$args[1]};
      } else {
        return [error=>{}, 'Usage: privset <user>[ <priv> (set|clear)]']; 
      }
      $ouser->set('privileges', \%priv);
      return [report=>{}, 'Privileges changed.'];
    }  
    
  },
  help => ['html:ul'=>{}, 
    ['html:li'=>{}, 'privset ',[meta=>{},'<user>'],' - list privileges'], 
    ['html:li'=>{}, 'privset ',[meta=>{},'<user>'],' ',[meta=>{},'<priv>'],' ',[meta=>{},'(set|clear)']," - change privileges"], 
  ],
},
#---------------------------------------------------------------------------------------------------
};
