Require 'core', 'commands';

use strict;

# '.' means the root list
Define '.' => {
  Socials => MDefList->new(type => 'HASH'),
};

Define Commands => {
#---------------------------------------------------------------------------------------------------
socials => {
  code => sub {
    my ($self, $args) = @_;
    
    if ($args) {
      # FIXME: this ought to be accessible from help
      my $socl = MDefList->root->get('Socials');
      (my $name) = $socl->prefix($args) or die "CFAIL:There is no such social.";
      my $soc = $socl->get($name);
      my $msg = $soc->{msg};
      my @advs = @{$soc->{advs} || []};
      $msg =~ s/<target>/<e:lt>target<e:gt>/;
      $msg =~ s/<target.poss>/<e:lt>target<e:gt>'s/;
      $msg =~ s/ADV/<e:lt>adverb<e:gt>/;
      return [report=>{},
        [title=>{}, "Social '$name'"],
        ['html:ul'=>{mark=>'indent'}, 
          ['html:li'=>{}, "Message: ", [ucfirst=>{}, desc_gen($msg,self=>$self)]],
          (@advs ? ['html:li'=>{}, "Available adverbs: ", ['html:ul'=>{'html:class'=>'compact'}, map ['html:li'=>{}, $_], @advs]] : ()),
        ]
      ];
    } else {
      return [report=>{},
        [title=>{}, "The 'social' commands are"],
        ['html:ul'=>{}, map ['html:li'=>{},$_], sort MDefList->root->get('Socials')->keys],
      ];
    }
  },
  help => <<'EOHELP',
socials

Lists the "social" commands. See 'help info:socials'.
EOHELP
},
#---------------------------------------------------------------------------------------------------
};

Define Hooks => {
  'special_command' => sub {
    my ($self, $con, $cmd, $args) = @_;
    my $name = (MDefList->root->get('Socials')->prefix($cmd))[0]
            || (MDefList->root->get('Socials')->prefix(Lingua::EN::Inflect::PL_V($cmd)))[0];
    return MEvent::Message->new(
      target => $self,
      method => 'do_social',
      arguments => [$name, $args],
    ) if $name;
    return;
  }
};

Define Methods => {
  'do_social' => sub {
    my ($self, $name, $args) = @_;
 
    my $soc = MDefList->root->get('Socials')->get($name) or die "CFAIL:No such social: $name";

    my @advs = @{$soc->{advs} || []};
    my ($adv, $target);
    if ($args =~ s/^(@{[join '|', @advs]})(\s+|$)//) {
      $adv = $1;
    } elsif ($args =~ s/(\s+|^)(@{[join '|', @advs]})$//) {
      $adv = $2;
    } elsif (my ($first, $space) = $args =~ /^(.*?)(\s+|$)/) {
      ($adv) = grep /^\Q$first/, @advs
        if length $first;
      $args =~ s/^$first$space// if $adv;
    }
    
    $args =~ s/^(at|to)\s+//;
    eval {
      $target = $self->object_find($args) if $args;
    };
    if ($@) {
      if (my $cf = parse_cfail()) {
        $self->send([error=>{}, $cf]);
        return;
      } else {
        die $@;
      }
    }
  
    my $mstr = $soc->{msg};
    $mstr =~ s/\[([^][]*?)ADV([^][]*?)\]/$adv ? "$1$adv$2" : ''/e;
    $mstr =~ s/\[([^][]*?<target[^][]*?)\]/$target ? $1 : ''/e;
    
    if (!$target and $mstr =~ /{target/) {
      $self->send([error=>{}, "You must specify who/what to $name!"]);
      return;
    }

    $self->nact($mstr, ($target ? (target => $target) : ()));
  },
};

# #c# comments are socials from CircleMUD that I don't have. 
# Definitely not going to implement some of them.

Define Socials => {
  applaud => {
    msg => '<self> <v:applauds>[ <target>].',
    advs => [qw()],
  },
  blink => {
    msg => '<self> <v:blinks>[ ADV][ at <target>].',
    advs => [qw(sleepily slowly repeatedly)],
  },
  blush => {
    msg => '<self> <v:blushes>[ ADV].',
    advs => [qw(slightly brightly)],
  },
  bow => {
    msg => '<self> <v:bows>[ ADV][ to <target>].',
    advs => [qw(slightly deeply sarcastically stiffly respectfully)],
  },
  burp => {
    msg => '<self> <v:burps>[ ADV].',
    advs => [qw(quietly loudly rudely)],
  },
  cackle => {
    msg => '<self> <v:cackles>[ ADV][ at <target>].',
    advs => [qw(loudly evilly wickedly insanely)],
    sound => 1.2,
  },
  chuckle => {
    msg => '<self> <v:chuckles>[ ADV][ at <target>].',
    advs => [qw(happily weakly loudly softly)],
    sound => 1,
  },
  cough => {
    msg => '<self> <v:coughs>[ ADV].',
    advs => [qw(weakly loudly softly)],
    sound => .4,
  },
  cringe => {
    msg => '<self> <v:cringes>[ away from <target>][ ADV].',
    advs => [qw(fearfully)],
  },
  #c#(special)cry,(special)dance
  drool => {
    msg => '<self> <v:drools>[ ADV][ on <target>].',
    advs => [qw(disgustingly)],
    touch => .1,
  },
  frown => {
    msg => '<self> <v:frowns>[ ADV][ at <target>].',
    advs => [qw(seriously angrily puzzledly disapprovingly)],
    sound => 1,
  },
  gasp => {
    msg => '<self> <v:gasps>[ in ADV][ at <target>].',
    advs => [qw(astonishment fright fear)],
    sound => 1,
  },
  giggle => {
    msg => '<self> <v:giggles>[ ADV][ at <target>].',
    advs => [qw(happily loudly softly uncontrollably)],
    sound => 1,
  },
  glare => {
    msg => '<self> <v:glares>[ ADV][ at <target>].',
    advs => [qw(angrily coldly icily)],
  },
  grin => {
    msg => '<self> <v:grins>[ ADV][ at <target>].',
    advs => [qw(happily slightly falsely nastily evilly hugely widely)],
  },
  groan => {
    msg => '<self> <v:groans>[ ADV][ at <target>].',
    advs => [qw(loudly softly weakly painfully tiredly)],
  },
  growl => {
    msg => '<self> <v:growls>[ ADV][ at <target>].',
    advs => [qw(playfully angrily menacingly softly loudly)],
  },
  hug => {
    msg => '<self> <v:hugs> <target>[ ADV].',
    advs => [qw(gently firmly tightly happily enthusiastically)],
    touch => 1,
  },
  kiss => {
    msg => '<self> <v:kisses>[ <target>]<target.used! the air>[ ADV].',
    advs => [qw(quickly firmly passionately)],
    consent => 1,
    touch => 1,
  },
  laugh => {
    msg => '<self> <v:laughs>[ ADV][ at <target>].',
    advs => [qw(happily weakly loudly softly)],
  },
  #c#moan
  nod => {
    msg => '<self> <v:nods>[ ADV][ to <target>].',
    advs => [qw(firmly violently slightly vaguely solemnly grimly respectfully)],
  },
  #c#nudge,pat
  point => {
    msg => '<self> <v:points>[ ADV] at <target>.',
    advs => [qw(firmly shakily)],
    touch => .2,
  },
  poke => {
    msg => '<self> <v:pokes> <target>[ ADV].',
    advs => [qw(gently firmly sharply hard)],
    touch => .2,
  },
  pout => {
    # ought to be a state
    msg => '<self> <v:pouts>.',
    advs => [qw()],
  },
  purr => {
    msg => '<self> <v:purrs>[ADV].',
    advs => [qw(softly loudly)],
    sound => .3,
  },
  scream => {
    msg => '<self> <v:screams>[ in ADV]!',
    advs => [qw(pain terror fright anger delight suprise)],
    sound => 3,
  },
  shakehead => {
    msg => '<self> <v:shakes> <self.pposs> head[ ADV][ at <target>].',
    advs => [qw(firmly violently slightly vaguely)],
  },
  shakehand => {
    msg => '<self> <v:shakes> <target.poss> hand[ ADV].',
    advs => [qw()],
    touch => .5,
  },
  shakebody => {
    msg => '<self> <v:shakes>[ <target>][ ADV].',
    advs => [qw(hard angrily slightly)],
    touch => .7,
  },
  shiver => {
    msg => '<self> <v:shivers>.',
    advs => [qw()],
  },
  shrug => {
    msg => '<self> <v:shrugs>.',
    advs => [qw()],
  },
  sigh => {
    msg => '<self> <v:sighs>[ ADV][ at <target>].',
    advs => [qw(happily loudly softly resignedly)],
  },
  # special: sing
  slap => {
    msg => '<self> <v:slaps>[ <target>][ ADV].',
    advs => [qw(hard)],
    touch => .8,
  },
  smile => {
    msg => '<self> <v:smiles>[ ADV][ at <target>].',
    advs => [qw(happily slightly falsely oddly broadly widely nonsensically)],
  },
  smirk => {
    msg => '<self> <v:smirks>[ ADV][ at <target>].',
    advs => [qw()],
  },
  #c#snarl,sneeze,snicker
  sniff => {
    msg => '<self> <v:sniffs>[ ADV][ at <target>].',
    advs => [qw()],
  },
  #c#snore
  # sob
  spit => {
    msg => '<self> <v:spits>[ ADV][ on <target>].',
    advs => [qw()],
  },
  stare => {
    msg => '<self> <v:stares>[ ADV] at <target>.',
    advs => [qw(angrily pointedly icily coldly quizzically)],
  },
  #c#sulk,tickle
  twiddle => {
    # ought to be a state
    msg => '<self> <v:twiddles>[ <target>][ ADV].',
    advs => [qw(boredly idly aimlessly)],
    tcarrying => 1,
  },
  wave => {
    msg => '<self> <v:waves>[ to <target>][ ADV].',
    advs => [qw(frantically happily vaguely cheerfully)],
  },
  whistle => {
    msg => '<self> <v:whistles>[ ADV][ at <target>].',
    advs => [qw(poorly cheerfully tunelessly appreciatively loudly softly shrilly)],
    sound => .6,
  },
  wink => {
    msg => '<self> <v:winks>[ ADV][ at <target>].',
    advs => [qw()],
    sound => .6,
  },
  yawn => {
    msg => '<self> <v:yawns>[ ADV].',
    advs => [qw(widely hugely slightly gently boredly sleepily)],
  },
  # special: yodel - needs to start and stop
};

Require 'help';
Require 'help';
Define Help => {
  socials => {
    keywords => "socials poses emotes",
    title => "Socials",
    body => ['html:pre'=>{}, <<'EOT'],
There are 'social commands' (abbreviated 'socials') which are for insignificant character actions which do not affect the game world at all. Example:
  > smile
  You smile.

You can also specify adverbs:
  > smile widely
  You smile widely.
  
Some actions may be directed at other objects:
  > nod at marn
  You nod to Marn.
  
Adverbs and targets may be used together, and the adverb can be abbreviated:
  > gl ang marn
  You glare angrily at Marn.
  
To get a list of all socials, type 'socials'. For information on what message a social produces, and what adverbs you can use with it, type 'help social:<name of the social>'.
EOT
  },
};