#!/usr/bin/perl -w
use strict;
use Test;
BEGIN { plan test => 8; }

use Mud::StorableSub;
my $the_class = 'Mud::StorableSub';

use vars qw($didCompile $didRun @runArgs);

my $sub = $the_class->new(q{
  BEGIN { $::didCompile++; }
  $::didRun++;
  @::runArgs = @_;
  42;
});

ok $sub->isa($the_class);

$sub->sub->('foo', 'bar', 'baz');

ok $didCompile, 1;
ok $didRun, 1;

ok $sub->sub->('foo'), 42;

ok $didCompile, 1;
ok $didRun, 2;

# Erk. This tests the internals. Not good, but I want
# to make sure that the cache is getting cleared right.
ok scalar keys %Mud::StorableSub::SubCache, 1;
undef $sub;
ok scalar keys %Mud::StorableSub::SubCache, 0;

